/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.lsp.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.model.lsp.internal.MappingUriExtensions;
import org.eclipse.smarthome.model.lsp.internal.RegistryProvider;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.xtext.ide.ExecutorServiceProvider;
import org.eclipse.xtext.ide.server.DefaultProjectDescriptionFactory;
import org.eclipse.xtext.ide.server.IProjectDescriptionFactory;
import org.eclipse.xtext.ide.server.IWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ProjectWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.containers.ProjectDescriptionBasedContainerManager;

public class RuntimeServerModule
extends AbstractModule {
    private final ScriptServiceUtil scriptServiceUtil;
    private final ScriptEngine scriptEngine;

    public RuntimeServerModule(ScriptServiceUtil scriptServiceUtil, ScriptEngine scriptEngine) {
        this.scriptServiceUtil = scriptServiceUtil;
        this.scriptEngine = scriptEngine;
    }

    protected void configure() {
        this.binder().bind(ExecutorService.class).toProvider(ExecutorServiceProvider.class);
        this.bind(UriExtensions.class).toInstance((Object)new MappingUriExtensions(ConfigConstants.getConfigFolder()));
        this.bind(LanguageServer.class).to(LanguageServerImpl.class);
        this.bind(IResourceServiceProvider.Registry.class).toProvider((Provider)new RegistryProvider(this.scriptServiceUtil, this.scriptEngine));
        this.bind(IWorkspaceConfigFactory.class).to(ProjectWorkspaceConfigFactory.class);
        this.bind(IProjectDescriptionFactory.class).to(DefaultProjectDescriptionFactory.class);
        this.bind(IContainer.Manager.class).to(ProjectDescriptionBasedContainerManager.class);
    }
}

