/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.mapdb.internal;

import java.io.File;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.storage.DeletableStorage;
import org.eclipse.smarthome.core.storage.DeletableStorageService;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.storage.mapdb.internal.MapDbStorage;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.eclipse.smarthome.storage.mapdb", immediate=true, service={StorageService.class, DeletableStorageService.class}, property={"storage.format=mapdb"})
public class MapDbStorageService
implements DeletableStorageService {
    private final Logger logger = LoggerFactory.getLogger(MapDbStorageService.class);
    private static final String DB_FILE_NAME = "storage.mapdb";
    private DB db;
    private String dbFolderName = "mapdb";

    @Activate
    public void activate() {
        this.dbFolderName = String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + this.dbFolderName;
        File folder = new File(this.dbFolderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File dbFile = new File(this.dbFolderName, DB_FILE_NAME);
        this.db = DBMaker.newFileDB((File)dbFile).closeOnJvmShutdown().make();
        this.logger.debug("Opened MapDB file at '{}'.", (Object)dbFile.getAbsolutePath());
    }

    @Deactivate
    public void deactivate() {
        this.db.close();
        this.logger.debug("Deactivated MapDB Storage Service.");
    }

    public <T> DeletableStorage<T> getStorage(String name, ClassLoader classLoader) {
        return new MapDbStorage(this.db, name, classLoader);
    }

    public <T> DeletableStorage<T> getStorage(String name) {
        return this.getStorage(name, null);
    }
}

