/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test.internal.java;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;

public class MissingServiceAnalyzer {
    private final PrintStream ps;
    private final BundleContext bundleContext;

    public MissingServiceAnalyzer(PrintStream ps, BundleContext bundleContext) {
        this.ps = ps;
        this.bundleContext = bundleContext;
    }

    public <T> void printMissingServiceDetails(Class<T> clazz) {
        ServiceReference scrReference = this.bundleContext.getServiceReference(ServiceComponentRuntime.class);
        if (scrReference != null) {
            ServiceComponentRuntime scr = (ServiceComponentRuntime)this.bundleContext.getService(scrReference);
            if (scr != null) {
                this.ps.println("Components implementing " + clazz.getName() + ":");
                this.printUnsatisfiedServices(scr, clazz.getName(), "");
            }
        } else {
            this.ps.println("SCR is not started! Add the SCR bundle to your launch config.");
        }
    }

    private <T> void printUnsatisfiedServices(ServiceComponentRuntime scr, String interfaceName, String prefix) {
        Bundle[] allBundlesArrays = this.getAllBundles();
        List<ComponentDescriptionDTO> descriptions = this.getComponentDescriptions(scr, interfaceName, allBundlesArrays);
        if (descriptions.isEmpty()) {
            this.ps.println(String.valueOf(prefix) + "No component implementing " + interfaceName + " is currently registered.");
            this.ps.println("Make sure to add the appropriate bundle and set 'Default Auto-Start=true' in the launch config.");
        } else {
            for (ComponentDescriptionDTO description : descriptions) {
                Collection configurations = scr.getComponentConfigurationDTOs(description);
                for (ComponentConfigurationDTO configuration : configurations) {
                    this.ps.println(String.valueOf(prefix) + configuration.id + " [" + this.getState(configuration.state) + "] " + description.implementationClass + " in " + description.bundle.symbolicName);
                    for (ReferenceDTO ref : this.getUnsatisfiedReferences(description, configuration)) {
                        this.ps.println(String.valueOf(prefix) + "\t" + ref.name + " (" + ref.interfaceName + ")");
                        this.printUnsatisfiedServices(scr, ref.interfaceName, String.valueOf(prefix) + "\t\t");
                    }
                }
            }
        }
    }

    private List<ReferenceDTO> getUnsatisfiedReferences(ComponentDescriptionDTO description, ComponentConfigurationDTO configuration) {
        Set unsatisfiedRefNames = Stream.of(configuration.unsatisfiedReferences).map(ref -> ref.name).collect(Collectors.toSet());
        return Stream.of(description.references).filter(ref -> unsatisfiedRefNames.contains(ref.name)).collect(Collectors.toList());
    }

    private List<ComponentDescriptionDTO> getComponentDescriptions(ServiceComponentRuntime scr, String interfaceName, Bundle[] allBundlesArrays) {
        return scr.getComponentDescriptionDTOs(allBundlesArrays).stream().filter(description -> Stream.of(description.serviceInterfaces).anyMatch(s -> s.equals(interfaceName))).collect(Collectors.toList());
    }

    private Bundle[] getAllBundles() {
        List<Bundle> allBundles = Arrays.stream(this.bundleContext.getBundles()).filter(b -> b.getHeaders().get("Fragment-Host") == null).collect(Collectors.toList());
        return allBundles.toArray(new Bundle[allBundles.size()]);
    }

    private String getState(int state) {
        switch (state) {
            case 1: {
                return "UNSATISFIED_CONFIGURATION";
            }
            case 2: {
                return "UNSATISFIED_REFERENCE";
            }
            case 4: {
                return "SATISFIED";
            }
            case 8: {
                return "ACTIVE";
            }
        }
        return String.valueOf(state);
    }
}

