/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.ITreeViewerState;

public abstract class AbstractRefreshStrategy<T>
implements Runnable {
    protected final IModelCommonContentProvider contentProvider;
    private final boolean preserveTreeViewerState;
    private Set<T> treeElementsToRefresh = null;

    public AbstractRefreshStrategy(IModelCommonContentProvider contentProvider, boolean preserveTreeViewerState) {
        Assert.isNotNull((Object)contentProvider);
        this.contentProvider = contentProvider;
        this.preserveTreeViewerState = preserveTreeViewerState;
    }

    public Set<T> getTreeElementsToRefresh() {
        if (this.treeElementsToRefresh == null) {
            this.treeElementsToRefresh = new HashSet<T>();
        }
        return this.treeElementsToRefresh;
    }

    @Override
    public final void run() {
        Viewer viewer;
        if (this.canRun() && (viewer = this.contentProvider.getViewer()) != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        ITreeViewerState state = null;
                        if (AbstractRefreshStrategy.this.preserveTreeViewerState) {
                            state = AbstractRefreshStrategy.this.contentProvider.recordViewerState();
                        }
                        AbstractRefreshStrategy.this.refresh(viewer);
                        if (AbstractRefreshStrategy.this.preserveTreeViewerState) {
                            AbstractRefreshStrategy.this.contentProvider.applyViewerState(state);
                        }
                    }
                }
            });
        }
    }

    protected boolean canRun() {
        return !this.getTreeElementsToRefresh().isEmpty();
    }

    protected final void refresh(Viewer viewer) {
        if (viewer instanceof StructuredViewer && this.shouldPerformSelectiveRefresh()) {
            this.performSelectiveRefresh((StructuredViewer)viewer);
        } else {
            viewer.refresh();
        }
    }

    protected abstract boolean shouldPerformSelectiveRefresh();

    protected abstract void performSelectiveRefresh(StructuredViewer var1);
}

