/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.domain.factory.EditingDomainFactoryListenerRegistry;
import org.eclipse.sphinx.emf.domain.factory.ITransactionalEditingDomainFactoryListener;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.explorer.sorters.NonFinalCommonViewerSorter;
import org.eclipse.sphinx.emf.explorer.sorters.OrderedAwareCommonViewerSorter;
import org.eclipse.sphinx.emf.messages.EMFMessages;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.internal.saving.ModelSavingPerformanceStats;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.ITreeViewerState;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.TreeViewerStateRecorder;
import org.eclipse.sphinx.platform.stats.IEventTypeEnumerator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ExtendedCommonNavigator
extends CommonNavigator
implements ITabbedPropertySheetPageContributor,
IViewerProvider,
ITransactionalEditingDomainFactoryListener {
    private IOperationHistoryListener affectedObjectsListener;
    protected Set<IPropertySheetPage> propertySheetPages = new HashSet<IPropertySheetPage>();
    protected IUndoContext undoContext;
    protected SaveablesProvider modelSaveablesProvider;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ((PropertySheet)part).getCurrentPage().dispose();
                ExtendedCommonNavigator.this.propertySheetPages.remove(((PropertySheet)part).getCurrentPage());
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    protected TreeViewerStateRecorder treeViewerStateRecorder = new TreeViewerStateRecorder();
    protected ITreeViewerState deferredViewerState = null;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (this.modelSaveablesProvider == null) {
            this.modelSaveablesProvider = this.createModelSaveablesProvider();
            ISaveablesLifecycleListener modelSaveablesLifecycleListener = this.createModelSaveablesLifecycleListener();
            this.modelSaveablesProvider.init(modelSaveablesLifecycleListener);
        }
        site.getPage().addPartListener(this.partListener);
        this.affectedObjectsListener = this.createAffectedObjectsListener();
        Assert.isNotNull((Object)this.affectedObjectsListener);
        EditingDomainFactoryListenerRegistry.INSTANCE.addListener(MetaModelDescriptorRegistry.ANY_MM, null, (ITransactionalEditingDomainFactoryListener)this, null);
        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains()) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        CommonViewer viewer = new CommonViewer(this.getViewSite().getId(), aParent, 770){

            protected void init() {
                super.init();
                DecoratingStyledCellLabelProvider labelProvider = (DecoratingStyledCellLabelProvider)this.getLabelProvider();
                DecorationContext decorationContext = new DecorationContext();
                decorationContext.putProperty(ITreeContentProvider.class.getName(), (Object)this.getContentProvider());
                labelProvider.setDecorationContext((IDecorationContext)decorationContext);
            }

            public void refresh(Object element, boolean updateLabels) {
                super.refresh(element, updateLabels);
                ExtendedCommonNavigator.this.treeViewerStateRecorder.applyState(ExtendedCommonNavigator.this.deferredViewerState);
                ExtendedCommonNavigator.this.deferredViewerState = ExtendedCommonNavigator.this.treeViewerStateRecorder.getDeferredState();
            }

            public void setSorter(ViewerSorter sorter) {
                if (sorter != null && sorter instanceof NonFinalCommonViewerSorter) {
                    ((NonFinalCommonViewerSorter)sorter).setContentService(this.getNavigatorContentService());
                }
                super.setSorter(sorter);
            }
        };
        this.treeViewerStateRecorder.setViewer((TreeViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getCommonViewer().setSorter((ViewerSorter)new OrderedAwareCommonViewerSorter());
        this.getNavigatorActionService().fillActionBars(this.getViewSite().getActionBars());
        this.restoreState(this.memento);
    }

    public boolean isDirty() {
        Saveable[] saveables;
        Saveable[] saveableArray = saveables = this.getActiveSaveables();
        int n = saveables.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable element = saveableArray[n2];
            if (element.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> saveables = new HashSet<Saveable>(Arrays.asList(super.getSaveables()));
        if (this.modelSaveablesProvider != null) {
            saveables.addAll(Arrays.asList(this.modelSaveablesProvider.getSaveables()));
        }
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    public Saveable[] getActiveSaveables() {
        String contextGetActiveSaveables = String.valueOf(ModelSavingPerformanceStats.ModelContext.CONTEXT_GET_ACTIVE_SAVEABLES.getName()) + ((Object)((Object)this)).getClass().getSimpleName();
        ModelSavingPerformanceStats.ModelEvent modelEvent = ModelSavingPerformanceStats.ModelEvent.EVENT_GET_SAVEABLE;
        ModelSavingPerformanceStats.INSTANCE.openContext(contextGetActiveSaveables);
        ModelSavingPerformanceStats.INSTANCE.startNewEvent((IEventTypeEnumerator)modelEvent, (Object)((Object)((Object)this)).getClass().getSimpleName());
        HashSet<Saveable> saveables = new HashSet<Saveable>(Arrays.asList(super.getActiveSaveables()));
        if (this.modelSaveablesProvider != null) {
            CommonViewer viewer = this.getCommonViewer();
            if (viewer != null) {
                if (viewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    for (Object selected : selection.toList()) {
                        if (selected instanceof IContainer) {
                            IContainer container = (IContainer)selected;
                            Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels(container);
                            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                                Saveable saveable = this.modelSaveablesProvider.getSaveable((Object)modelDescriptor);
                                if (saveable == null) continue;
                                saveables.add(saveable);
                            }
                            continue;
                        }
                        Saveable saveable = this.modelSaveablesProvider.getSaveable(selected);
                        if (saveable == null) continue;
                        saveables.add(saveable);
                    }
                }
            } else {
                saveables.addAll(Arrays.asList(this.modelSaveablesProvider.getSaveables()));
            }
        }
        ModelSavingPerformanceStats.INSTANCE.endEvent((IEventTypeEnumerator)modelEvent, (Object)((Object)((Object)this)).getClass().getSimpleName());
        ModelSavingPerformanceStats.INSTANCE.closeAndLogContext(contextGetActiveSaveables);
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    public String getContributorId() {
        return this.getViewSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        if (adapter == IUndoContext.class) {
            return this.getUndoContext();
        }
        return super.getAdapter(adapter);
    }

    public Viewer getViewer() {
        return this.getCommonViewer();
    }

    public TreeViewerStateRecorder getViewerStateRecorder() {
        return this.treeViewerStateRecorder;
    }

    public void dispose() {
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
        }
        this.modelSaveablesProvider = null;
        this.getSite().getPage().removePartListener(this.partListener);
        for (IPropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        this.propertySheetPages.clear();
        if (this.affectedObjectsListener != null) {
            for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains()) {
                WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(this.affectedObjectsListener);
            }
            EditingDomainFactoryListenerRegistry.INSTANCE.removeListener((ITransactionalEditingDomainFactoryListener)this);
        }
        this.affectedObjectsListener = null;
        super.dispose();
    }

    public void restoreState(IMemento memento) {
        this.treeViewerStateRecorder.restoreState(memento);
        this.deferredViewerState = this.treeViewerStateRecorder.getDeferredState();
    }

    public void saveState(IMemento memento) {
        this.treeViewerStateRecorder.saveState(memento);
        super.saveState(memento);
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        if (input instanceof IStructuredSelection) {
            try {
                StructuredSelection selection = (StructuredSelection)input;
                this.selectReveal((ISelection)selection);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            return super.show(context);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Collection<TransactionalEditingDomain> getEditingDomainsFromSelection() {
        ISelection selection;
        HashSet<TransactionalEditingDomain> editingDomains = new HashSet<TransactionalEditingDomain>();
        CommonViewer viewer = this.getCommonViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                if (selected instanceof EObject && ((EObject)selected).eIsProxy()) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)EMFMessages.warning_selectionContainsUnresolvedModelElement, selected)));
                    continue;
                }
                if (selected instanceof IProject || selected instanceof IFolder) {
                    editingDomains.addAll(WorkspaceEditingDomainUtil.getEditingDomains((IContainer)((IContainer)selected)));
                    continue;
                }
                TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain(selected);
                if (editingDomain == null) continue;
                editingDomains.add(editingDomain);
            }
        }
        return editingDomains;
    }

    public IPropertySheetPage getPropertySheetPage() {
        TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    protected IUndoContext getUndoContext() {
        if (this.undoContext == null) {
            this.undoContext = new ObjectUndoContext((Object)this, String.valueOf(this.getContributorId()) + ".context");
        }
        return this.undoContext;
    }

    protected boolean isActivePart() {
        IWorkbenchPartSite site = this.getSite();
        return site != null ? this == site.getWorkbenchWindow().getPartService().getActivePart() : false;
    }

    protected boolean isMyActivePropertySheetPage() {
        IWorkbenchPart activePart;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (activePart = site.getWorkbenchWindow().getPartService().getActivePart()) instanceof PropertySheet) {
            return this.propertySheetPages.contains(((PropertySheet)activePart).getCurrentPage());
        }
        return false;
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected IOperationHistoryListener createAffectedObjectsListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 1) {
                    this.handleOperationAboutToExecute(event.getOperation());
                } else if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    this.handleOperationFinished(event.getOperation());
                }
            }

            private void handleOperationAboutToExecute(final IUndoableOperation operation) {
                IWorkbenchPartSite site;
                if (operation.canUndo() && (site = ExtendedCommonNavigator.this.getSite()) != null) {
                    site.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ExtendedCommonNavigator.this.isActivePart() || ExtendedCommonNavigator.this.isMyActivePropertySheetPage()) {
                                for (TransactionalEditingDomain editingDomain : ExtendedCommonNavigator.this.getEditingDomainsFromSelection()) {
                                    IUndoContext undoContext;
                                    CommandStack commandStack = editingDomain.getCommandStack();
                                    if (!(commandStack instanceof IWorkspaceCommandStack) || (undoContext = ((IWorkspaceCommandStack)commandStack).getDefaultUndoContext()) == null) continue;
                                    operation.removeContext(undoContext);
                                }
                                operation.addContext(ExtendedCommonNavigator.this.getUndoContext());
                            }
                        }
                    });
                }
            }

            private void handleOperationFinished(final IUndoableOperation operation) {
                IWorkbenchPartSite site = ExtendedCommonNavigator.this.getSite();
                if (site != null) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Collection affectedObjects;
                            Command command;
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null && (affectedObjects = command.getAffectedObjects()).size() > 0) {
                                try {
                                    StructuredSelection selection = new StructuredSelection(affectedObjects.toArray());
                                    ExtendedCommonNavigator.this.selectReveal((ISelection)selection);
                                }
                                catch (RuntimeException runtimeException) {}
                            }
                        }
                    });
                }
            }
        };
    }

    protected ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    ExtendedCommonNavigator.this.firePropertyChange(257);
                }
            }
        };
    }

    public void postCreateEditingDomain(TransactionalEditingDomain editingDomain) {
        WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
    }

    public void preDisposeEditingDomain(TransactionalEditingDomain editingDomain) {
        if (this.affectedObjectsListener != null) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(this.affectedObjectsListener);
        }
    }
}

