/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.ui.fields.BasicField;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RangeField
extends BasicField {
    private int fItemCount;
    private Label[] fLabelsControls;
    private String[] fLabels;
    private String[] fTexts;
    private Text[] fTextsControls;
    private ModifyListener[] fModifyListeners;
    private int fStyle = 2052;

    private void doModifyText(ModifyEvent e) {
        int i = 0;
        while (i < this.fItemCount) {
            if (e.widget.equals(this.fTextsControls[i]) && this.isOkToUse((Control)this.fTextsControls[i])) {
                this.fTexts[i] = this.fTextsControls[i].getText();
                break;
            }
            ++i;
        }
        this.dialogFieldChanged();
    }

    private Label createLabelControl(Composite parent, int i) {
        if (this.fLabelsControls[i] == null) {
            this.assertCompositeNotNull(parent);
            this.fLabelsControls[i] = new Label(parent, 16448);
            this.fLabelsControls[i].setFont(parent.getFont());
            this.fLabelsControls[i].setEnabled(this.isEnabled());
            if (this.fLabels[i] != null && !"".equals(this.fLabels[i])) {
                this.fLabelsControls[i].setText(this.fLabels[i]);
            } else {
                this.fLabelsControls[i].setText(".");
                this.fLabelsControls[i].setVisible(false);
            }
        }
        return this.fLabelsControls[i];
    }

    private Text getTextControl(Composite parent, int i) {
        if (this.fTextsControls[i] == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListeners[i] = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeField.this.doModifyText(e);
                }
            };
            this.fTextsControls[i] = new Text(parent, this.fStyle);
            this.fTextsControls[i].setText(this.fTexts[i]);
            this.fTextsControls[i].setFont(parent.getFont());
            this.fTextsControls[i].addModifyListener(this.fModifyListeners[i]);
            this.fTextsControls[i].setEnabled(this.isEnabled());
        }
        return this.fTextsControls[i];
    }

    private void setLabelText(String text, int i) {
        this.fLabels[i] = text;
        if (this.isOkToUse((Control)this.fLabelsControls[i])) {
            this.fLabelsControls[i].setText(text);
        }
    }

    private void setText(String text, int i) {
        this.fTexts[i] = text;
        if (this.isOkToUse((Control)this.fTextsControls[i])) {
            this.fTextsControls[i].setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    private void setTextWithoutUpdate(String text, int i) {
        this.fTexts[i] = text;
        if (this.isOkToUse((Control)this.fTextsControls[i])) {
            this.fTextsControls[i].removeModifyListener(this.fModifyListeners[i]);
            this.fTextsControls[i].setText(text);
            this.fTextsControls[i].addModifyListener(this.fModifyListeners[i]);
        }
    }

    @Override
    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        ArrayList<Object> controls = new ArrayList<Object>();
        int i = 0;
        while (i < this.fItemCount) {
            Label label = this.createLabelControl(parent, i);
            if (this.fUseFormLayout) {
                label.setLayoutData((Object)LayoutUtil.tableWrapDataForLabel(1));
            } else {
                label.setLayoutData((Object)LayoutUtil.gridDataForLabel(1));
            }
            controls.add(label);
            Text text = this.getTextControl(parent, i);
            if (this.fUseFormLayout) {
                text.setLayoutData((Object)LayoutUtil.tableWrapDataForText(nColumns / 2 - 1));
            } else {
                text.setLayoutData((Object)LayoutUtil.gridDataForText(nColumns / 2 - 1));
            }
            controls.add(text);
            ++i;
        }
        return controls.toArray(new Control[controls.size()]);
    }

    @Override
    protected int getNumberOfControls() {
        return 4;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        int i = 0;
        while (i < this.fItemCount) {
            if (this.isOkToUse((Control)this.fTextsControls[i])) {
                this.fTextsControls[i].setEnabled(this.isEnabled());
            }
            ++i;
        }
    }

    public RangeField(int itemCount) {
        this(null, itemCount);
    }

    public RangeField(IWidgetFactory widgetFactory, int itemCount) {
        super(widgetFactory);
        this.fItemCount = itemCount;
        this.fTexts = new String[itemCount];
        this.fLabels = new String[itemCount];
        this.fTextsControls = new Text[itemCount];
        this.fLabelsControls = new Label[itemCount];
        this.fModifyListeners = new ModifyListener[itemCount];
        int i = 0;
        while (i < itemCount) {
            this.fTexts[i] = "";
            this.fLabels[i] = "";
            ++i;
        }
    }

    public RangeField(int itemCount, int style) {
        this(itemCount);
        this.fStyle = style;
    }

    public String[] getTexts() {
        String[] copy = new String[this.fItemCount];
        int i = 0;
        while (i < this.fItemCount) {
            copy[i] = this.fTexts[i];
            ++i;
        }
        return copy;
    }

    public Text[] getTextControls() {
        return this.fTextsControls;
    }

    @Override
    public void refresh() {
        super.refresh();
        int i = 0;
        while (i < this.fItemCount) {
            if (this.isOkToUse((Control)this.fTextsControls[i])) {
                this.setTextWithoutUpdate(this.fTexts[i], i);
            }
            ++i;
        }
    }

    @Override
    public boolean setFocus() {
        return true;
    }

    public void setLabels(String[] labels) {
        if (labels.length != this.fItemCount) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)PlatformMessages.warning_unexpectedArrayLength);
        }
        int i = 0;
        while (i < labels.length && i < this.fItemCount) {
            this.setLabelText(labels[i], i);
            ++i;
        }
    }

    public void setTexts(String[] texts) {
        if (texts.length != this.fItemCount) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)PlatformMessages.warning_unexpectedArrayLength);
        }
        int i = 0;
        while (i < texts.length && i < this.fItemCount) {
            this.setText(texts[i], i);
            ++i;
        }
    }

    public void setTextEnabled(boolean b) {
        int i = 0;
        while (i < this.fItemCount) {
            if (this.isOkToUse((Control)this.fTextsControls[i])) {
                this.fTextsControls[i].setEnabled(b);
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.fItemCount) {
            if (this.isOkToUse((Control)this.fTextsControls[i])) {
                this.fTextsControls[i].dispose();
            }
            if (this.isOkToUse((Control)this.fLabelsControls[i])) {
                this.fLabelsControls[i].dispose();
            }
            ++i;
        }
    }
}

