/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.sections;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalEditorActionBarContributor;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractFormSection;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.ITreeViewerState;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.TreeViewerStateRecorder;
import org.eclipse.sphinx.platform.util.ReflectUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public abstract class AbstractViewerFormSection
extends AbstractFormSection
implements IViewerProvider {
    @Deprecated
    protected StructuredViewer viewer;
    private Viewer privateViewer;
    private ITreeViewerState viewerState = null;
    private TreeViewerStateRecorder treeViewerStateRecorder = new TreeViewerStateRecorder();
    private IContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;

    public AbstractViewerFormSection(AbstractFormPage formPage, Object sectionInput) {
        super(formPage, sectionInput);
    }

    public AbstractViewerFormSection(AbstractFormPage formPage, Object sectionInput, int style) {
        super(formPage, sectionInput, style);
    }

    protected void recordViewerState() {
        if (this.viewerState == null) {
            this.viewerState = this.treeViewerStateRecorder.recordState();
        }
    }

    protected void applyViewerState() {
        this.treeViewerStateRecorder.applyState(this.viewerState);
        this.viewerState = null;
    }

    @Override
    public void setSectionInput(Object sectionInput) {
        super.setSectionInput(sectionInput);
        if (this.privateViewer != null) {
            Object oldViewerInput = this.privateViewer.getInput();
            Object newViewerInput = this.getViewerInput();
            if (newViewerInput != oldViewerInput) {
                this.privateViewer.setInput(newViewerInput);
            }
        }
        this.applyViewerState();
    }

    public Viewer getViewer() {
        return this.privateViewer;
    }

    public void setViewer(Viewer viewer) {
        this.privateViewer = viewer;
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
        if (viewer instanceof TreeViewer) {
            this.treeViewerStateRecorder.setViewer((TreeViewer)viewer);
        }
    }

    public Object getViewerInput() {
        return this.sectionInput;
    }

    @Override
    protected Composite doCreateSectionClient(final IManagedForm managedForm, final SectionPart sectionPart) {
        Composite composite = super.doCreateSectionClient(managedForm, sectionPart);
        if (this.privateViewer != null) {
            this.formPage.getTransactionalFormEditor().setSelectionProvider((ISelectionProvider)this.privateViewer);
            this.privateViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    managedForm.fireSelectionChanged((IFormPart)sectionPart, event.getSelection());
                    AbstractViewerFormSection.this.formPage.getTransactionalFormEditor().setSelectionProvider((ISelectionProvider)AbstractViewerFormSection.this.privateViewer);
                }
            });
            this.createViewerContextMenu();
        }
        return composite;
    }

    @Override
    public boolean isEmpty() {
        if (this.privateViewer != null) {
            try {
                Object[] filteredChildren = (Object[])ReflectUtil.invokeInvisibleMethod((Object)this.privateViewer, (String)"getFilteredChildren", (Object[])new Object[]{this.getViewerInput()});
                return filteredChildren.length == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void focusGained(FocusEvent e) {
        super.focusGained(e);
        EditingDomainActionBarContributor actionBarContributor = this.formPage.getTransactionalFormEditor().getActionBarContributor();
        if (actionBarContributor instanceof BasicTransactionalEditorActionBarContributor) {
            ((BasicTransactionalEditorActionBarContributor)actionBarContributor).setGlobalActionHandlers();
        }
    }

    public IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    protected IContentProvider createContentProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getCustomAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.formPage.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return this.formPage.getContentProvider();
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createLabelProvider();
        }
        return this.labelProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getCustomAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.formPage.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return this.formPage.getLabelProvider();
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected void createViewerContextMenu() {
    }
}

