/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.Activator;
import org.eclipse.sphinx.emf.validation.ui.util.Messages;
import org.eclipse.sphinx.emf.validation.ui.views.ActionCopyMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ActionMarkerProperties;
import org.eclipse.sphinx.emf.validation.ui.views.ActionOpenMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ActionPasteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ActionRemoveMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ActionRevealMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ActionSelectAll;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.DefaultMarkerResourceAdapter;
import org.eclipse.sphinx.emf.validation.ui.views.DialogMarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.FilterEnablementAction;
import org.eclipse.sphinx.emf.validation.ui.views.FiltersAction;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerAdapter;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerList;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSupportRegistry;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerViewPreferenceDialog;
import org.eclipse.sphinx.emf.validation.ui.views.ProblemMarker;
import org.eclipse.sphinx.emf.validation.ui.views.ShowInMenu;
import org.eclipse.sphinx.emf.validation.ui.views.TableView;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public abstract class MarkerView
extends TableView {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_ID = "id";
    private static final String TAG_FILTERS_SECTION = "filters";
    private static final String TAG_FILTER_ENTRY = "filter";
    private static final String MENU_FILTERS_GROUP = "group.filter";
    private static final String MENU_SHOW_IN_GROUP = "group.showIn";
    private static final String OLD_FILTER_SECTION = "filter";
    static final Object MARKER_UPDATE_FAMILY = new Object();
    MarkerProcessJob markerProcessJob = new MarkerProcessJob();
    private UpdateJob updateJob = new UpdateJob();
    private int preBusyMarkers = 0;
    protected Object[] focusElements;
    private Clipboard clipboard;
    IResourceChangeListener markerUpdateListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.hasMarkerDelta(event)) {
                return;
            }
            if (event.getType() == 16) {
                MarkerView.this.scheduleMarkerUpdate(100);
                return;
            }
            IWorkbenchSiteProgressService progressService = MarkerView.this.getProgressService();
            if (progressService == null) {
                MarkerView.this.markerProcessJob.schedule(30000L);
            } else {
                MarkerView.this.getProgressService().schedule((Job)MarkerView.this.markerProcessJob, 30000L);
            }
        }

        private boolean hasMarkerDelta(IResourceChangeEvent event) {
            String[] markerTypes;
            String[] stringArray = markerTypes = MarkerView.this.getMarkerTypes();
            int n = markerTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (event.findMarkerDeltas(element, true).length > 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };
    private ContextProvider contextProvider = new ContextProvider();
    protected ActionCopyMarker copyAction;
    protected ActionPasteMarker pasteAction;
    protected SelectionProviderAction revealAction;
    protected SelectionProviderAction openAction;
    protected SelectionProviderAction deleteAction;
    protected SelectionProviderAction selectAllAction;
    protected SelectionProviderAction propertiesAction;
    protected UndoActionHandler undoAction;
    protected RedoActionHandler redoAction;
    private ISelectionListener focusListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            MarkerView.this.focusSelectionChanged(part, selection);
        }
    };
    private int totalMarkers = 0;
    private MarkerFilter[] markerFilters = new MarkerFilter[0];
    private MarkerFilter[] enabledFilters = null;
    private MenuManager filtersMenu;
    private MenuManager showInMenu;
    private IPropertyChangeListener workingSetListener;
    private MarkerAdapter adapter;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(MarkerView.this.getFiltersPreferenceName())) {
                MarkerView.this.loadFiltersPreferences();
                MarkerView.this.clearEnabledFilters();
                MarkerView.this.refreshForFocusUpdate();
            }
        }
    };

    public MarkerView() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public MarkerList getCurrentMarkers() {
        return this.getMarkerAdapter().getCurrentMarkers();
    }

    protected MarkerAdapter getMarkerAdapter() {
        return this.adapter;
    }

    public void updateForContentsRefresh(IProgressMonitor monitor) {
        this.updateJob.cancel();
        this.getMarkerAdapter().buildAllMarkers(monitor);
        this.getProgressService().schedule((Job)this.updateJob);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
            this.getProgressService().showBusyForFamily(MARKER_UPDATE_FAMILY);
        }
        this.loadFiltersPreferences();
    }

    private void loadFiltersPreferences() {
        String preference = Activator.getDefault().getPreferenceStore().getString(this.getFiltersPreferenceName());
        if (preference.equals("")) {
            this.createDefaultFilter();
            return;
        }
        StringReader reader = new StringReader(preference);
        try {
            this.restoreFilters((IMemento)XMLMemento.createReadRoot((Reader)reader));
        }
        catch (WorkbenchException e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)e));
        }
    }

    void updateForFilterChanges() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeFiltersSettings(memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log(Util.errorStatus(e));
        }
        Activator.getDefault().getPreferenceStore().putValue(this.getFiltersPreferenceName(), writer.toString());
        Activator.getDefault().savePluginPreferences();
        this.clearEnabledFilters();
        this.refreshFilterMenu();
        this.refreshViewer();
    }

    protected void writeFiltersSettings(XMLMemento memento) {
        MarkerFilter[] filters;
        MarkerFilter[] markerFilterArray = filters = this.getUserFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerFilter element = markerFilterArray[n2];
            IMemento child = memento.createChild("filter", element.getName());
            element.saveFilterSettings(child);
            ++n2;
        }
    }

    abstract String getFiltersPreferenceName();

    void restoreFilters(IMemento memento) {
        IMemento[] sections = null;
        if (memento != null) {
            sections = memento.getChildren("filter");
        }
        if (sections == null) {
            IDialogSettings mainSettings = this.getDialogSettings();
            IDialogSettings filtersSection = mainSettings.getSection("filter");
            if (filtersSection != null) {
                MarkerFilter markerFilter = this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName);
                markerFilter.restoreFilterSettings(filtersSection);
                this.setFilters(new MarkerFilter[]{markerFilter});
            }
        } else {
            MarkerFilter[] newFilters = new MarkerFilter[sections.length];
            int i = 0;
            while (i < sections.length) {
                newFilters[i] = this.createFilter(sections[i].getID());
                newFilters[i].restoreState(sections[i]);
                ++i;
            }
            this.setFilters(newFilters);
        }
        if (this.markerFilters.length == 0) {
            this.createDefaultFilter();
        }
    }

    private void createDefaultFilter() {
        MarkerFilter filter = this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName);
        this.setFilters(new MarkerFilter[]{filter});
    }

    protected abstract MarkerFilter createFilter(String var1);

    protected abstract String getSectionTag();

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        super.createPartControl(parent);
        this.initDragAndDrop();
        this.getSite().getPage().addSelectionListener(this.focusListener);
        this.focusSelectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.getWorkingSetListener());
        this.getViewer().getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                IContext context = MarkerView.this.contextProvider.getContext(MarkerView.this.getViewer().getControl());
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.markerUpdateListener, 25);
    }

    public Object getAdapter(Class adaptable) {
        if (adaptable.equals(IContextProvider.class)) {
            return this.contextProvider;
        }
        if (adaptable.equals(IShowInSource.class)) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ISelection selection = MarkerView.this.getViewer().getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return null;
                    }
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    Iterator markerIterator = structured.iterator();
                    ArrayList<IResource> newSelection = new ArrayList<IResource>();
                    while (markerIterator.hasNext()) {
                        Object obj = markerIterator.next();
                        if (!(obj instanceof ConcreteMarker)) continue;
                        ConcreteMarker element = (ConcreteMarker)obj;
                        newSelection.add(element.getResource());
                    }
                    return new ShowInContext(MarkerView.this.getViewer().getInput(), (ISelection)new StructuredSelection(newSelection));
                }
            };
        }
        return super.getAdapter(adaptable);
    }

    protected void viewerSelectionChanged(IStructuredSelection selection) {
        Object[] rawSelection = selection.toArray();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        Object[] objectArray = rawSelection;
        int n = rawSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ConcreteMarker) {
                markers.add(((ConcreteMarker)element).getMarker());
            }
            ++n2;
        }
        this.setSelection((IStructuredSelection)new StructuredSelection(markers));
        this.updateStatusMessage(selection);
    }

    public void dispose() {
        super.dispose();
        this.cancelJobs();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.markerUpdateListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        this.getSite().getPage().removeSelectionListener(this.focusListener);
        if (this.openAction != null) {
            this.openAction.dispose();
            this.copyAction.dispose();
            this.selectAllAction.dispose();
            this.deleteAction.dispose();
            this.revealAction.dispose();
            this.propertiesAction.dispose();
            this.undoAction.dispose();
            this.redoAction.dispose();
            this.clipboard.dispose();
        }
        if (this.showInMenu != null) {
            this.showInMenu.dispose();
        }
    }

    protected void createActions() {
        this.revealAction = new ActionRevealMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.openAction = new ActionOpenMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.copyAction = new ActionCopyMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.copyAction.setClipboard(this.clipboard);
        this.copyAction.setProperties(this.getSortingFields());
        this.pasteAction = new ActionPasteMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        this.pasteAction.setClipboard(this.clipboard);
        this.pasteAction.setPastableTypes(this.getMarkerTypes());
        this.deleteAction = new ActionRemoveMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        this.selectAllAction = new ActionSelectAll(this);
        this.propertiesAction = new ActionMarkerProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        IUndoContext undoContext = this.getUndoContext();
        this.undoAction = new UndoActionHandler(this.getSite(), undoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), undoContext);
        super.createActions();
        this.setFilterAction(new FiltersAction(this));
        this.setPreferencesAction(new ViewPreferencesAction(){

            public void openViewPreferencesDialog() {
                MarkerView.this.openPreferencesDialog(MarkerView.this.getMarkerEnablementPreferenceName(), MarkerView.this.getMarkerLimitPreferenceName());
            }
        });
    }

    private void openPreferencesDialog(String markerEnablementPreferenceName, String markerLimitPreferenceName) {
        MarkerViewPreferenceDialog dialog = new MarkerViewPreferenceDialog(this.getSite().getWorkbenchWindow().getShell(), markerEnablementPreferenceName, markerLimitPreferenceName, MarkerMessages.MarkerPreferences_DialogTitle);
        if (dialog.open() == 0) {
            this.refreshViewer();
        }
    }

    abstract String getMarkerLimitPreferenceName();

    abstract String[] getMarkerTypes();

    protected void initToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.deleteAction);
        tbm.add(this.getFilterAction());
        tbm.update(false);
    }

    protected void registerGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
    }

    protected void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                MarkerView.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.getViewer().addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    private void performDragSetData(DragSourceEvent event) {
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            List selection = ((IStructuredSelection)this.getViewer().getSelection()).toList();
            try {
                IMarker[] markers = new IMarker[selection.size()];
                selection.toArray(markers);
                if (markers != null) {
                    event.data = this.copyAction.createMarkerReport(markers);
                }
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
    }

    private IMarker[] getSelectedMarkers() {
        Object[] selection = ((IStructuredSelection)this.getViewer().getSelection()).toArray();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ConcreteMarker) {
                markers.add(((ConcreteMarker)element).getMarker());
            }
            ++n2;
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (manager == null) {
            return;
        }
        manager.add((IAction)this.openAction);
        this.createShowInMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        this.pasteAction.updateEnablement();
        manager.add((IAction)this.pasteAction);
        if (this.canBeEditable()) {
            manager.add((IAction)this.deleteAction);
        }
        manager.add((IAction)this.selectAllAction);
        this.fillContextMenuAdditions(manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    boolean canBeEditable() {
        return true;
    }

    abstract void fillContextMenuAdditions(IMenuManager var1);

    protected final MarkerFilter[] getUserFilters() {
        return this.markerFilters;
    }

    protected void handleKeyPressed(KeyEvent event) {
    }

    protected void handleOpenEvent(OpenEvent event) {
        if (this.openAction.isEnabled()) {
            this.openAction.run();
        }
    }

    protected void saveSelection(IMemento memento) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        IMemento selectionMem = memento.createChild(TAG_SELECTION);
        for (Object next : selection) {
            if (!(next instanceof ConcreteMarker)) continue;
            ConcreteMarker marker = (ConcreteMarker)next;
            IMemento elementMem = selectionMem.createChild(TAG_MARKER);
            elementMem.putString(TAG_RESOURCE, marker.getMarker().getResource().getFullPath().toString());
            elementMem.putString(TAG_ID, String.valueOf(marker.getMarker().getId()));
        }
    }

    protected abstract String[] getRootTypes();

    protected void focusSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof CommonNavigator)) {
            return;
        }
        ArrayList<Object> selectedElements = new ArrayList<Object>();
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            IFile file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
            if (file == null) {
                Object mapping;
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput != null && (mapping = editorInput.getAdapter(ResourceMapping.class)) != null) {
                    selectedElements.add(mapping);
                }
            } else {
                selectedElements.add(file);
            }
        } else if (selection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)selection) {
                Object obj;
                if (object instanceof IAdaptable) {
                    Object adapter = ((IAdaptable)object).getAdapter(ITaskListResourceAdapter.class);
                    ITaskListResourceAdapter taskListResourceAdapter = adapter != null && adapter instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)adapter : DefaultMarkerResourceAdapter.getDefault();
                    IResource resource = taskListResourceAdapter.getAffectedResource((IAdaptable)object);
                    if (resource == null) {
                        Object mapping = ((IAdaptable)object).getAdapter(ResourceMapping.class);
                        if (mapping == null) continue;
                        selectedElements.add(mapping);
                        continue;
                    }
                    selectedElements.add(resource);
                    continue;
                }
                if (object instanceof EObject) {
                    selectedElements.add(object);
                    continue;
                }
                if (!(object instanceof IWrapperItemProvider) || !((obj = ((IWrapperItemProvider)object).getValue()) instanceof EObject)) continue;
                selectedElements.add(obj);
            }
        }
        this.updateFocusMarkers(selectedElements.toArray());
    }

    protected final void updateFilterSelection(Object[] elements) {
        ArrayList<Object> selectionCollection = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                selectionCollection.add(element);
            } else if (element instanceof ResourceMapping) {
                this.addResources(selectionCollection, (ResourceMapping)element);
            } else if (element instanceof EObject) {
                selectionCollection.add(element);
            } else if (element instanceof IWrapperItemProvider) {
                selectionCollection.add(element);
            }
            ++n2;
        }
        Object[] selections = new Object[selectionCollection.size()];
        selectionCollection.toArray(selections);
        MarkerFilter[] markerFilterArray = this.markerFilters;
        int n3 = this.markerFilters.length;
        n = 0;
        while (n < n3) {
            MarkerFilter element = markerFilterArray[n];
            element.setFocusSelection(selections);
            ++n;
        }
        for (MarkerFilter filter : MarkerSupportRegistry.getInstance().getRegisteredFilters()) {
            filter.setFocusSelection(selections);
        }
    }

    private void addResources(Collection resources, ResourceMapping mapping) {
        try {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] result;
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] iResourceArray = result = traversal.getResources();
                int n3 = result.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    resources.add(element);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Util.log(e);
            return;
        }
    }

    protected abstract String getStaticContextId();

    protected void updateFocusMarkers(Object[] elements) {
        boolean updateNeeded = this.updateNeeded(this.focusElements, elements);
        if (updateNeeded) {
            this.focusElements = elements;
            this.refreshForFocusUpdate();
        }
    }

    private boolean updateNeeded(Object[] oldElements, Object[] newElements) {
        MarkerFilter[] filters = this.getEnabledFilters();
        boolean updateNeeded = false;
        MarkerFilter[] markerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            int onResource;
            MarkerFilter filter = markerFilterArray[n2];
            if (filter.isEnabled() && (onResource = filter.getOnResource()) != 0 && onResource != 4 && newElements != null && newElements.length >= 1) {
                if (oldElements == null || oldElements.length < 1) {
                    return true;
                }
                if (!Arrays.equals(oldElements, newElements)) {
                    if (onResource == 3) {
                        Collection oldProjects = MarkerFilter.getProjectsAsCollection(oldElements);
                        Collection newProjects = MarkerFilter.getProjectsAsCollection(newElements);
                        if (oldProjects.size() != newProjects.size() || !newProjects.containsAll(oldProjects)) {
                            return true;
                        }
                    } else {
                        updateNeeded = true;
                    }
                }
            }
            ++n2;
        }
        return updateNeeded;
    }

    void updateTitle() {
        int totalCount;
        String status = Util.EMPTY_STRING;
        int filteredCount = this.getCurrentMarkers().getItemCount();
        status = filteredCount == (totalCount = this.getTotalMarkers()) ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)new Integer(totalCount)) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)new Integer(filteredCount), (Object)new Integer(totalCount));
        this.setContentDescription(status);
    }

    protected void updateStatusMessage() {
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.updateStatusMessage((IStructuredSelection)selection);
        } else {
            this.updateStatusMessage(null);
        }
    }

    protected void updateStatusMessage(IStructuredSelection selection) {
        String message = "";
        if (selection == null || selection.size() == 0) {
            message = this.updateSummaryVisible();
        } else if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof ConcreteMarker) {
                message = ((ConcreteMarker)first).getDescription();
            }
        } else if (selection.size() > 1) {
            message = this.updateSummarySelected(selection);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected String updateSummarySelected(IStructuredSelection selection) {
        return MessageFormat.format(MarkerMessages.marker_statusSummarySelected, new Integer(selection.size()));
    }

    protected String updateSummaryVisible() {
        return "";
    }

    public final void openFiltersDialog() {
        DialogMarkerFilter dialog = this.createFiltersDialog();
        if (dialog.open() == 0) {
            MarkerFilter[] result = dialog.getFilters();
            if (result == null) {
                return;
            }
            if (result.length == 0) {
                this.setFilters(new MarkerFilter[]{this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName)});
            } else {
                this.setFilters(result);
            }
            this.updateForFilterChanges();
        }
    }

    public void refreshViewer() {
        this.scheduleMarkerUpdate(100);
    }

    void setFilters(MarkerFilter[] newFilters) {
        this.markerFilters = newFilters;
    }

    void clearEnabledFilters() {
        this.enabledFilters = null;
    }

    private void refreshFilterMenu() {
        MarkerFilter[] filters;
        if (this.filtersMenu == null) {
            return;
        }
        this.filtersMenu.removeAll();
        MarkerFilter[] markerFilterArray = filters = this.getAllFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerFilter element = markerFilterArray[n2];
            this.filtersMenu.add((IAction)new FilterEnablementAction(element, this));
            ++n2;
        }
    }

    protected abstract DialogMarkerFilter createFiltersDialog();

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        TreeViewer viewer = this.getViewer();
        ArrayList<ConcreteMarker> newSelection = new ArrayList<ConcreteMarker>(structuredSelection.size());
        for (Object next : structuredSelection) {
            ConcreteMarker marker;
            if (!(next instanceof IMarker) || (marker = this.getCurrentMarkers().getMarker((IMarker)next)) == null) continue;
            newSelection.add(marker);
        }
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(newSelection), reveal);
        }
    }

    protected MarkerList getVisibleMarkers() {
        return this.getCurrentMarkers();
    }

    int getTotalMarkers() {
        return this.totalMarkers;
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (busy) {
            this.preBusyMarkers = this.totalMarkers;
        } else if (this.totalMarkers != this.preBusyMarkers) {
            this.getProgressService().warnOfContentChange();
        }
    }

    protected MarkerFilter[] getEnabledFilters() {
        if (this.enabledFilters == null) {
            Collection filters = this.findEnabledFilters();
            this.enabledFilters = new MarkerFilter[filters.size()];
            filters.toArray(this.enabledFilters);
        }
        return this.enabledFilters;
    }

    protected Collection findEnabledFilters() {
        MarkerFilter[] allFilters = this.getAllFilters();
        ArrayList<MarkerFilter> filters = new ArrayList<MarkerFilter>(0);
        MarkerFilter[] markerFilterArray = allFilters;
        int n = allFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerFilter element = markerFilterArray[n2];
            if (element.isEnabled()) {
                filters.add(element);
            }
            ++n2;
        }
        return filters;
    }

    MarkerFilter[] getAllFilters() {
        return this.getUserFilters();
    }

    void addDropDownContributions(IMenuManager menu) {
        super.addDropDownContributions(menu);
        menu.add((IContributionItem)new Separator(MENU_FILTERS_GROUP));
        this.filtersMenu = new MenuManager(MarkerMessages.filtersSubMenu_title);
        this.refreshFilterMenu();
        menu.appendToGroup(MENU_FILTERS_GROUP, (IContributionItem)this.filtersMenu);
    }

    void createShowInMenu(IMenuManager menu) {
        String keyBinding;
        ISelection selection = this.getViewer().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)selection;
        if (!Util.isSingleConcreteSelection(structured)) {
            return;
        }
        menu.add((IContributionItem)new Separator(MENU_SHOW_IN_GROUP));
        String showInLabel = Messages._UI_Workbench_showIn;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            showInLabel = String.valueOf(showInLabel) + '\t' + keyBinding;
        }
        ProblemMarker marker = (ProblemMarker)structured.getFirstElement();
        String targetObjectURI = null;
        try {
            targetObjectURI = (String)marker.getMarker().getAttribute("uri");
        }
        catch (CoreException coreException) {}
        this.showInMenu = new MenuManager(showInLabel);
        if (targetObjectURI == null || targetObjectURI.equals("")) {
            this.showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
        } else {
            ExtendedContributionItemFactory contributionItemFactory = new ExtendedContributionItemFactory("extendedViewsShowIn");
            contributionItemFactory.setTargetObject(targetObjectURI);
            this.showInMenu.add(contributionItemFactory.create(this.getViewSite().getWorkbenchWindow()));
        }
        menu.appendToGroup(MENU_SHOW_IN_GROUP, (IContributionItem)this.showInMenu);
    }

    void refreshMarkerCounts(IProgressMonitor monitor) {
        monitor.subTask(MarkerMessages.MarkerView_refreshing_counts);
        try {
            this.totalMarkers = MarkerList.compute(this.getMarkerTypes()).length;
        }
        catch (CoreException e) {
            Util.log(e);
            return;
        }
    }

    int getMarkerLimit() {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(this.getMarkerEnablementPreferenceName())) {
            return IDEWorkbenchPlugin.getDefault().getPreferenceStore().getInt(this.getMarkerLimitPreferenceName());
        }
        return -1;
    }

    abstract String getMarkerEnablementPreferenceName();

    Object createViewerInput() {
        this.adapter = new MarkerAdapter(this);
        return this.adapter;
    }

    public void addUpdateFinishListener(IJobChangeListener listener) {
        this.updateJob.addJobChangeListener(listener);
    }

    public void removeUpdateFinishListener(IJobChangeListener listener) {
        this.updateJob.removeJobChangeListener(listener);
    }

    private IPropertyChangeListener getWorkingSetListener() {
        this.workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MarkerView.this.clearEnabledFilters();
                MarkerView.this.refreshViewer();
            }
        };
        return this.workingSetListener;
    }

    void scheduleMarkerUpdate(int time) {
        this.cancelJobs();
        this.getProgressService().schedule((Job)this.markerProcessJob, (long)time);
    }

    private void cancelJobs() {
        this.markerProcessJob.cancel();
        this.updateJob.cancel();
    }

    protected Tree createTree(Composite parent) {
        Tree tree = super.createTree(parent);
        tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                MarkerView.this.updateJob.removeExpandedCategory((MarkerAdapter.MarkerCategory)e.item.getData());
            }

            public void treeExpanded(TreeEvent e) {
                MarkerView.this.updateJob.addExpandedCategory((MarkerAdapter.MarkerCategory)e.item.getData());
            }
        });
        return tree;
    }

    private void refreshForFocusUpdate() {
        if (this.focusElements != null) {
            this.updateFilterSelection(this.focusElements);
            this.refreshViewer();
        }
    }

    protected void preserveSelection() {
        this.updateJob.saveSelection(this.getViewer().getSelection());
    }

    protected abstract String getMarkerName();

    protected IUndoContext getUndoContext() {
        return (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
    }

    private class ContextProvider
    implements IContextProvider {
        private ContextProvider() {
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            String contextId = null;
            ConcreteMarker marker = this.getSelectedConcreteMarker();
            if (marker != null) {
                contextId = IDE.getMarkerHelpRegistry().getHelp(marker.getMarker());
            }
            if (contextId == null) {
                contextId = MarkerView.this.getStaticContextId();
            }
            return HelpSystem.getContext(contextId);
        }

        private ConcreteMarker getSelectedConcreteMarker() {
            IStructuredSelection selection = (IStructuredSelection)MarkerView.this.getViewer().getSelection();
            if (selection.isEmpty()) {
                return null;
            }
            if (selection.getFirstElement() instanceof ConcreteMarker) {
                return (ConcreteMarker)selection.getFirstElement();
            }
            return null;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }

    private class ExtendedContributionItemFactory
    extends ContributionItemFactory {
        private String targetObjectURI;

        public ExtendedContributionItemFactory(String contributionItemId) {
            super(contributionItemId);
            this.targetObjectURI = null;
        }

        public void setTargetObject(String uri) {
            this.targetObjectURI = uri;
        }

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            return new ShowInMenu(window, this.getId(), this.targetObjectURI);
        }
    }

    class MarkerProcessJob
    extends Job {
        MarkerProcessJob() {
            super(MarkerMessages.MarkerView_processUpdates);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            MarkerView.this.updateForContentsRefresh(monitor);
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return PlatformUI.isWorkbenchRunning();
        }

        public boolean belongsTo(Object family) {
            return MARKER_UPDATE_FAMILY == family;
        }
    }

    private class UpdateJob
    extends WorkbenchJob {
        private Collection categoriesToExpand;
        private Collection preservedSelection;

        UpdateJob() {
            super(MarkerMessages.MarkerView_queueing_updates);
            this.categoriesToExpand = new HashSet();
            this.preservedSelection = new ArrayList();
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            int n;
            int n2;
            MarkerNode[] markerNodeArray;
            if (MarkerView.this.getViewer().getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            MarkerView.this.getViewer().refresh(true);
            Tree tree = MarkerView.this.getTree();
            if (tree != null && !tree.isDisposed()) {
                MarkerView.this.updateStatusMessage();
                MarkerView.this.updateTitle();
                if (MarkerView.this.getCurrentMarkers().getSize() < 20) {
                    MarkerView.this.getViewer().expandAll();
                } else {
                    MarkerAdapter.MarkerCategory[] categories = MarkerView.this.getMarkerAdapter().getCategories();
                    if (categories == null) {
                        this.categoriesToExpand.clear();
                    } else if (categories.length == 1) {
                        MarkerView.this.getViewer().expandAll();
                        this.categoriesToExpand.clear();
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        this.categoriesToExpand.add(categories[0].getName());
                    } else {
                        HashSet<String> newCategories = new HashSet<String>();
                        markerNodeArray = categories;
                        n2 = categories.length;
                        n = 0;
                        while (n < n2) {
                            MarkerNode category = markerNodeArray[n];
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (this.categoriesToExpand.contains(((MarkerAdapter.MarkerCategory)category).getName())) {
                                MarkerView.this.getViewer().expandToLevel((Object)category, -1);
                                newCategories.add(((MarkerAdapter.MarkerCategory)category).getName());
                            }
                            ++n;
                        }
                        this.categoriesToExpand = newCategories;
                    }
                }
            }
            if (this.preservedSelection.size() > 0) {
                ArrayList<ConcreteMarker> newSelection = new ArrayList<ConcreteMarker>();
                ConcreteMarker[] markers = MarkerView.this.getCurrentMarkers().toArray();
                markerNodeArray = markers;
                n2 = markers.length;
                n = 0;
                while (n < n2) {
                    ConcreteMarker element = markerNodeArray[n];
                    for (MarkerDescriptor next : this.preservedSelection) {
                        if (!next.isEquivalentTo(element)) continue;
                        newSelection.add(element);
                    }
                    ++n;
                }
                MarkerView.this.getViewer().setSelection((ISelection)new StructuredSelection(newSelection.toArray()), true);
                this.preservedSelection.clear();
            }
            if (MarkerView.this.getViewer().getTree().getItemCount() > 0) {
                MarkerView.this.getViewer().getTree().setTopItem(MarkerView.this.getViewer().getTree().getItem(0));
            }
            return Status.OK_STATUS;
        }

        public void addExpandedCategory(MarkerAdapter.MarkerCategory category) {
            this.categoriesToExpand.add(category.getName());
        }

        public void removeExpandedCategory(MarkerAdapter.MarkerCategory category) {
            this.categoriesToExpand.remove(category.getName());
        }

        public boolean belongsTo(Object family) {
            return family == MARKER_UPDATE_FAMILY;
        }

        public void saveSelection(ISelection selection) {
            this.preservedSelection.clear();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                for (MarkerNode next : structured) {
                    if (!next.isConcrete()) continue;
                    this.preservedSelection.add(new MarkerDescriptor(next.getConcreteRepresentative()));
                }
            }
        }

        public boolean shouldRun() {
            return !MarkerView.this.getMarkerAdapter().isBuilding();
        }

        private class MarkerDescriptor {
            String description;
            String folder;
            String resource;
            int line;

            MarkerDescriptor(ConcreteMarker marker) {
                this.description = marker.getDescription();
                this.folder = marker.getFolder();
                this.resource = marker.getResourceName();
                this.line = marker.getLine();
            }

            boolean isEquivalentTo(ConcreteMarker marker) {
                return marker.getDescription().equals(this.description) && marker.getFolder().equals(this.folder) && marker.getResourceName().equals(this.resource) && marker.getLine() == this.line;
            }
        }
    }
}

