/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.actions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicAutoMergeAction
extends BaseSelectionListenerAction
implements ISelectionChangedListener {
    protected ComparisonSnapshot comparisonSnapshot;
    protected List<WeakReference<EObject>> selectedObjects = null;
    protected List<WeakReference<IFile>> selectedFiles = null;

    public BasicAutoMergeAction() {
        super(Messages.action_mergeWithEachOther);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        if (selection.size() != 2) {
            return false;
        }
        this.comparisonSnapshot = null;
        this.selectedFiles = null;
        this.selectedObjects = null;
        for (Object obj : selection) {
            IFile file;
            if (obj instanceof EObject) {
                if (this.selectedObjects == null) {
                    this.selectedObjects = new ArrayList<WeakReference<EObject>>();
                }
                this.selectedObjects.add(new WeakReference<EObject>((EObject)obj));
                continue;
            }
            if (!(obj instanceof IFile) || MetaModelDescriptorRegistry.INSTANCE.getDescriptor(file = (IFile)obj) == null) continue;
            if (this.selectedFiles == null) {
                this.selectedFiles = new ArrayList<WeakReference<IFile>>();
            }
            this.selectedFiles.add(new WeakReference<IFile>(file));
        }
        return this.selectedFiles != null ? this.selectedFiles.size() == 2 : (this.selectedObjects != null ? this.selectedObjects.size() == 2 : false);
    }

    public void run() {
        EObject leftObject = null;
        EObject rightObject = null;
        if (this.selectedObjects != null && this.selectedObjects.size() == 2) {
            leftObject = (EObject)this.selectedObjects.get(0).get();
            rightObject = (EObject)this.selectedObjects.get(1).get();
        } else if (this.selectedFiles != null && this.selectedFiles.size() == 2) {
            leftObject = this.getModelRoot((IFile)this.selectedFiles.get(0).get());
            rightObject = this.getModelRoot((IFile)this.selectedFiles.get(1).get());
        }
        if (leftObject == null || rightObject == null) {
            return;
        }
        int direction = this.promptMergeDirection(leftObject, rightObject);
        EObject rightEObject = rightObject;
        EObject leftEObject = leftObject;
        switch (direction) {
            case -1: {
                break;
            }
            case 0: {
                this.mergeModelElements(rightEObject, leftEObject, true);
                break;
            }
            case 1: {
                this.mergeModelElements(rightEObject, leftEObject, false);
            }
        }
    }

    protected EObject getModelRoot(IFile file) {
        Assert.isNotNull((Object)file);
        return EcorePlatformUtil.loadModelRoot((IFile)file);
    }

    protected int promptMergeDirection(EObject leftObject, EObject rightObject) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(AdapterUtils.getAdapterFactory());
        Resource leftResource = leftObject.eResource();
        IFile leftFile = EcorePlatformUtil.getFile((Resource)leftResource);
        IProject leftProject = leftFile.getProject();
        Resource rightResource = rightObject.eResource();
        IFile rightFile = EcorePlatformUtil.getFile((Resource)rightResource);
        IProject rightProject = rightFile.getProject();
        String leftProperties = NLS.bind((String)Messages.dlg_mergeAuto_messageLeftProperties, (Object[])new Object[]{leftProject.getName(), leftFile.getName(), labelProvider.getText((Object)leftObject)});
        String rightProperties = NLS.bind((String)Messages.dlg_mergeAuto_messageRightProperties, (Object[])new Object[]{rightProject.getName(), rightFile.getName(), labelProvider.getText((Object)rightObject)});
        String[] dialogButtonLabels = new String[]{Messages.dlg_mergeAuto_buttonLabel_leftToRight, Messages.dlg_mergeAuto_buttonLabel_rightToLeft, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = new MessageDialog(ExtendedPlatformUI.getActiveShell(), Messages.dlg_mergeAuto_title, null, String.valueOf(Messages.dlg_mergeAuto_message) + "\n" + leftProperties + "\n" + rightProperties, 3, dialogButtonLabels, 0);
        int result = dialog.open();
        if (result == 2) {
            result = -1;
        }
        return result;
    }

    protected void mergeModelElements(EObject rightEObject, EObject leftEObject, boolean leftToRight) {
        TransactionalEditingDomain leftEditingDomain;
        TransactionalEditingDomain rightEditingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)rightEObject);
        if (rightEditingDomain.equals(leftEditingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)leftEObject))) {
            this.executeInIndividualTransaction(rightEObject, leftEObject, leftEditingDomain, leftToRight);
        } else if (leftToRight) {
            this.executeInAggregateTransactions(rightEObject, leftEObject, rightEditingDomain, leftEditingDomain, leftToRight);
        } else {
            this.executeInAggregateTransactions(rightEObject, leftEObject, leftEditingDomain, rightEditingDomain, leftToRight);
        }
    }

    protected void executeInIndividualTransaction(final EObject rightEObject, final EObject leftEObject, TransactionalEditingDomain leftEditingDomain, final boolean leftToRight) {
        try {
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)leftEditingDomain, (Runnable)new Runnable(){

                public void run() {
                    BasicAutoMergeAction.this.doRun(rightEObject, leftEObject, leftToRight);
                }
            }, (String)Messages.action_mergeWithEachOther);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    protected void executeInAggregateTransactions(final EObject rightEObject, final EObject leftEObject, TransactionalEditingDomain outerTransactionEditingDomain, final TransactionalEditingDomain innerTransactionEditingDomain, final boolean leftToRight) {
        try {
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)outerTransactionEditingDomain, (Runnable)new Runnable(){

                public void run() {
                    try {
                        WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)innerTransactionEditingDomain, (Runnable)new Runnable(){

                            public void run() {
                                BasicAutoMergeAction.this.doRun(rightEObject, leftEObject, leftToRight);
                            }
                        }, (String)Messages.action_mergeWithEachOther);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                    }
                    catch (ExecutionException ex) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                    }
                }
            }, (String)Messages.action_mergeWithEachOther);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    protected void doRun(EObject rightEObject, EObject leftEObject, boolean leftToRight) {
        try {
            MatchModel matchModel = MatchService.doContentMatch((EObject)leftEObject, (EObject)rightEObject, null);
            DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
            MergeService.merge((List)diffModel.getOwnedElements(), (boolean)leftToRight);
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }
}

