/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.sphinx.emf.search.ui.MatchEvent;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.ModelSearchQuery;

public class ModelSearchResult
implements ISearchResult {
    private static final ModelSearchMatch[] EMPTY_ARRAY = new ModelSearchMatch[0];
    private ModelSearchQuery query;
    private final ListenerList listeners;
    private final Map<Object, List<ModelSearchMatch>> elementsToMatches;
    private final MatchEvent matchEvent;

    public ModelSearchResult(ModelSearchQuery query) {
        this.query = query;
        this.listeners = new ListenerList();
        this.elementsToMatches = new HashMap<Object, List<ModelSearchMatch>>();
        this.matchEvent = new MatchEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelSearchMatch[] getMatches(Object element) {
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            List<ModelSearchMatch> matches = this.elementsToMatches.get(element);
            if (matches != null) {
                return matches.toArray(new ModelSearchMatch[matches.size()]);
            }
            return EMPTY_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatch(ModelSearchMatch match) {
        boolean hasAdded = false;
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            hasAdded = this.doAddMatch(match);
        }
        if (hasAdded) {
            this.fireChange(this.getSearchResultEvent(match, 1));
        }
    }

    private boolean doAddMatch(ModelSearchMatch match) {
        List<ModelSearchMatch> matches = this.elementsToMatches.get(match.getElement());
        if (matches == null) {
            matches = new ArrayList<ModelSearchMatch>();
            this.elementsToMatches.put(match.getElement(), matches);
            matches.add(match);
            return true;
        }
        if (!matches.contains(match)) {
            matches.add(match);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatches(ModelSearchMatch[] matches) {
        ArrayList<ModelSearchMatch> reallyAdded = new ArrayList<ModelSearchMatch>();
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            ModelSearchMatch[] modelSearchMatchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                ModelSearchMatch matche = modelSearchMatchArray[n2];
                if (this.doAddMatch(matche)) {
                    reallyAdded.add(matche);
                }
                ++n2;
            }
        }
        if (!reallyAdded.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(reallyAdded, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements() {
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            return this.elementsToMatches.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            this.doRemoveAll();
        }
        this.fireChange((SearchResultEvent)new RemoveAllEvent((ISearchResult)this));
    }

    private void doRemoveAll() {
        this.elementsToMatches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(ModelSearchMatch match) {
        boolean existed = false;
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            existed = this.doRemoveMatch(match);
        }
        if (existed) {
            this.fireChange(this.getSearchResultEvent(match, 2));
        }
    }

    private boolean doRemoveMatch(ModelSearchMatch match) {
        boolean existed = false;
        List<ModelSearchMatch> matches = this.elementsToMatches.get(match.getElement());
        if (matches != null) {
            existed = matches.remove(match);
            if (matches.isEmpty()) {
                this.elementsToMatches.remove(match.getElement());
            }
        }
        return existed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatches(ModelSearchMatch[] matches) {
        ArrayList<ModelSearchMatch> existing = new ArrayList<ModelSearchMatch>();
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            ModelSearchMatch[] modelSearchMatchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                ModelSearchMatch matche = modelSearchMatchArray[n2];
                if (this.doRemoveMatch(matche)) {
                    existing.add(matche);
                }
                ++n2;
            }
        }
        if (!existing.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(existing, 2));
        }
    }

    protected void fireChange(SearchResultEvent e) {
        Object[] listeners2;
        Object[] objectArray = listeners2 = this.listeners.getListeners();
        int n = listeners2.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((ISearchResultListener)l).searchResultChanged(e);
            ++n2;
        }
    }

    private MatchEvent getSearchResultEvent(ModelSearchMatch match, int eventKind) {
        this.matchEvent.setKind(eventKind);
        this.matchEvent.setMatch(match);
        return this.matchEvent;
    }

    private MatchEvent getSearchResultEvent(Collection<ModelSearchMatch> matches, int eventKind) {
        this.matchEvent.setKind(eventKind);
        ModelSearchMatch[] matchArray = matches.toArray(new ModelSearchMatch[matches.size()]);
        this.matchEvent.setMatches(matchArray);
        return this.matchEvent;
    }

    public void addListener(ISearchResultListener searchResultListener) {
        this.listeners.add((Object)searchResultListener);
    }

    public void removeListener(ISearchResultListener searchResultListener) {
        this.listeners.remove((Object)searchResultListener);
    }

    public String getLabel() {
        return this.query.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchCount() {
        int count = 0;
        Map<Object, List<ModelSearchMatch>> map = this.elementsToMatches;
        synchronized (map) {
            for (List<ModelSearchMatch> matches : this.elementsToMatches.values()) {
                if (matches == null) continue;
                count += matches.size();
            }
        }
        return count;
    }

    public int getMatchCount(Object element) {
        List<ModelSearchMatch> matches = this.elementsToMatches.get(element);
        if (matches != null) {
            return matches.size();
        }
        return 0;
    }
}

