/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text;

import java.util.HashMap;
import org.eclipse.pde.internal.core.text.DocumentXMLNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.PDETextHelper;

public class DocumentTextNode
extends DocumentXMLNode
implements IDocumentTextNode {
    private static final long serialVersionUID = 1L;
    protected static final HashMap<Character, String> SUBSTITUTE_CHARS = new HashMap(5);
    private transient int fOffset = -1;
    private transient int fLength = 0;
    private transient IDocumentElementNode fEnclosingElement = null;
    private String fText;

    static {
        SUBSTITUTE_CHARS.put(Character.valueOf('&'), "&amp;");
        SUBSTITUTE_CHARS.put(Character.valueOf('<'), "&lt;");
        SUBSTITUTE_CHARS.put(Character.valueOf('>'), "&gt;");
        SUBSTITUTE_CHARS.put(Character.valueOf('\''), "&apos;");
        SUBSTITUTE_CHARS.put(Character.valueOf('\"'), "&quot;");
    }

    @Override
    public void setEnclosingElement(IDocumentElementNode node) {
        this.fEnclosingElement = node;
    }

    @Override
    public IDocumentElementNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    @Override
    public void setText(String text) {
        this.fText = text;
    }

    @Override
    public String getText() {
        return this.fText == null ? "" : this.fText;
    }

    @Override
    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public void setLength(int length) {
        this.fLength = length;
    }

    @Override
    public void reconnect(IDocumentElementNode parent) {
        this.fEnclosingElement = parent;
        this.fLength = -1;
        this.fOffset = -1;
    }

    @Override
    public String write() {
        String content = this.getText().trim();
        return PDETextHelper.translateWriteText(content, SUBSTITUTE_CHARS);
    }

    @Override
    public int getXMLType() {
        return 2;
    }
}

