/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;

public class RuntimeMetaData {
    public static final String VERSION = "4.3";
    private static final Collection<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public static synchronized void addListener(@NotNull Listener listener) {
        boolean containedDefault = listeners.remove(DefaultListener.INSTANCE);
        listeners.add(listener);
        if (containedDefault) {
            listeners.add(DefaultListener.INSTANCE);
        }
    }

    public static synchronized boolean removeListener(@NotNull Listener listener) {
        return listeners.remove(listener);
    }

    public static synchronized void clearListeners() {
        listeners.clear();
    }

    @NotNull
    public static String getRuntimeVersion() {
        return VERSION;
    }

    public static void checkVersion(@Nullable String toolVersion, @NotNull String compileTimeVersion) {
        boolean report = false;
        String message = null;
        if (toolVersion != null && !VERSION.equals(toolVersion)) {
            report = true;
            message = String.format("ANTLR Tool version %s used for code generation does not match the current runtime version %s", toolVersion, VERSION);
        } else if (!VERSION.equals(compileTimeVersion)) {
            report = true;
            message = String.format("ANTLR Runtime version %s used for parser compilation does not match the current runtime version %s", compileTimeVersion, VERSION);
        }
        if (report) {
            VersionMismatchException ex = new VersionMismatchException(message, toolVersion, compileTimeVersion);
            for (Listener listener : listeners) {
                listener.reportVersionMismatch(ex);
            }
        }
    }

    static {
        listeners.add(DefaultListener.INSTANCE);
    }

    public static class DefaultListener
    implements Listener {
        public static final DefaultListener INSTANCE = new DefaultListener();

        @Override
        public void reportVersionMismatch(@NotNull VersionMismatchException ex) throws VersionMismatchException {
            if (!this.isMinorVersionMatch(ex)) {
                throw ex;
            }
        }

        protected boolean isMinorVersionMatch(@NotNull VersionMismatchException ex) {
            String generatingToolVersion = ex.generatingToolVersion;
            if (generatingToolVersion != null && !this.getMajorMinorVersion(RuntimeMetaData.VERSION).equals(this.getMajorMinorVersion(generatingToolVersion))) {
                return false;
            }
            return this.getMajorMinorVersion(RuntimeMetaData.VERSION).equals(this.getMajorMinorVersion(ex.compileTimeRuntimeVersion));
        }

        @NotNull
        protected String getMajorMinorVersion(@NotNull String version) {
            int firstDot = version.indexOf(46);
            int secondDot = firstDot >= 0 ? version.indexOf(46, firstDot + 1) : -1;
            int firstDash = version.indexOf(45);
            int referenceLength = version.length();
            if (secondDot >= 0) {
                referenceLength = Math.min(referenceLength, secondDot);
            }
            if (firstDash >= 0) {
                referenceLength = Math.min(referenceLength, firstDash);
            }
            return version.substring(0, referenceLength);
        }
    }

    public static interface Listener {
        public void reportVersionMismatch(@NotNull VersionMismatchException var1) throws VersionMismatchException;
    }

    public static class VersionMismatchException
    extends RuntimeException {
        @Nullable
        public final String generatingToolVersion;
        @NotNull
        public final String compileTimeRuntimeVersion;

        VersionMismatchException(@NotNull String message, @Nullable String generatingToolVersion, @NotNull String compileTimeRuntimeVersion) {
            super(message);
            this.generatingToolVersion = generatingToolVersion;
            this.compileTimeRuntimeVersion = compileTimeRuntimeVersion;
        }
    }
}

