/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.LoggerPropertyEditor;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.LoggerPropertyEditorAdapter;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.LoggerPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.wizards.LoggerWizardMessages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LoggerPropertyComposite
extends Composite {
    private Map<Logger, LoggerPropertyEditor> modelMap = new HashMap<Logger, LoggerPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public LoggerPropertyComposite(Composite parent, int style, Logger[] loggers, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(LoggerWizardMessages.getString("LPC.Label"));
        LoggerPropertyEditor firstOne = null;
        if (loggers != null) {
            int i = 0;
            while (i < loggers.length) {
                LoggerPropertyEditorAdapter dmpea = (LoggerPropertyEditorAdapter)LoggerPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)loggers[i], LoggerPropertyEditorAdapter.class);
                LoggerPropertyEditor dmpe = dmpea.createLoggerPropertyEditor(this, 0, projectValidator, project);
                this.modelMap.put(loggers[i], dmpe);
                if (firstOne == null) {
                    firstOne = dmpe;
                }
                ++i;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    void displayLogger(Logger logger) {
        LoggerPropertyEditor dmpe = this.modelMap.get(logger);
        if (dmpe != null) {
            this.stackLayout.topControl = dmpe;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(LoggerWizardMessages.getString("LPC.Error")) + logger.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((LoggerPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((LoggerPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populateLogger(Logger logger) {
        ((LoggerPropertyEditor)this.stackLayout.topControl).populate(logger);
    }
}

