/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.stem.loggers.SimulationLoggerPackage;
import org.eclipse.stem.loggers.SynchronousDecoratorPropertyLogger;
import org.eclipse.stem.loggers.impl.SimulationLoggerImpl;

public abstract class SynchronousDecoratorPropertyLoggerImpl
extends SimulationLoggerImpl
implements SynchronousDecoratorPropertyLogger {
    public static final String copyright = "Copyright (c) 2011 IBM Corporation and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n    IBM Corporation - initial API and implementation";
    protected EList<String> properties;
    Map<URI, Map<String, EList<String>>> decoratorIdentifierProperties;

    protected SynchronousDecoratorPropertyLoggerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SimulationLoggerPackage.Literals.SYNCHRONOUS_DECORATOR_PROPERTY_LOGGER;
    }

    @Override
    public EList<String> getProperties() {
        if (this.properties == null) {
            this.properties = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 6);
        }
        return this.properties;
    }

    @Override
    public Map<String, EList<String>> getDecoratorProperties(URI decoratorURI) {
        if (this.decoratorIdentifierProperties == null) {
            this.decoratorIdentifierProperties = new HashMap<URI, Map<String, EList<String>>>();
            for (String propertyDescription : this.getProperties()) {
                try {
                    BasicEList propertyList;
                    String[] tokens = propertyDescription.split("\\#");
                    if (tokens.length <= 1) continue;
                    URI uri = URI.createURI((String)tokens[0]);
                    String identifierProperty = tokens[1];
                    String[] propertyElements = identifierProperty.split("\\/");
                    if (propertyElements.length <= 1) continue;
                    String identifier = propertyElements[0];
                    String property = propertyElements[1];
                    Map<String, EList<String>> decoratorData = this.decoratorIdentifierProperties.get(uri);
                    if (decoratorData == null) {
                        decoratorData = new HashMap<String, EList<String>>();
                        this.decoratorIdentifierProperties.put(uri, decoratorData);
                    }
                    if ((propertyList = decoratorData.get(identifier)) == null) {
                        propertyList = new BasicEList();
                        decoratorData.put(identifier, (EList<String>)propertyList);
                    }
                    propertyList.add((Object)property);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.decoratorIdentifierProperties.get(decoratorURI);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.properties != null && !this.properties.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (properties: ");
        result.append(this.properties);
        result.append(')');
        return result.toString();
    }
}

