/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stem.loggers.csv.logger.Constants;

public class FileUtils {
    public static String getRootLoggingFolderForScenario(String scenarioURL) {
        IPath path1;
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        boolean stemProjectScenario = scenarioURL.startsWith("platform:/resource/");
        if (stemProjectScenario) {
            String scenarioRelativePath = scenarioURL.substring("platform:/resource/".length());
            path1 = workspacePath.append(scenarioRelativePath).removeLastSegments(2);
        } else {
            path1 = workspacePath.append("BuiltInScenarios");
        }
        String path = path1.append(Constants.SYSTEM_PATH_SEPARATOR).append("Recorded Simulations").toOSString();
        return path;
    }

    public static void safeClose(Writer w) {
        try {
            w.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void safeClose(OutputStream os) {
        try {
            os.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

