/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.io.File;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.ColorScaleComposite;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.adapters.color.StandardColorProvider;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;
import org.eclipse.stem.ui.views.geographic.map.SelectedReportsManager;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonTransform;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MapCanvas
extends Canvas
implements ISelectionProvider,
PaintListener,
MouseWheelListener,
MouseMoveListener,
DisposeListener,
IPropertyChangeListener {
    private static final int TOOLTIP_HIDE_DELAY = 30000;
    private static final double INITIAL_ZOOM_FACTOR = 1.0;
    private static final double INITIAL_X_TRANSLATION = 0.0;
    private static final double INITIAL_Y_TRANSLATION = 0.0;
    protected static final double ZOOMING_FACTOR = 1.1;
    protected static final double UNZOOMING_FACTOR = 0.9090909090909091;
    private StemPolygonsList polygonsToRender;
    double zoomFactor = 1.0;
    private float gainFactor = 1.0f;
    private double xTranslation = 0.0;
    private double yTranslation = 0.0;
    boolean drawPolygonBorders = true;
    StemPolygonTransform pointsTransformer = new StemPolygonTransform();
    boolean toUpdateTranform = true;
    private final StandardColorProvider stdColorProvider = new StandardColorProvider((Device)this.getDisplay());
    private ColorProviderAdapter colorProvider = null;
    private boolean useLogScaling = true;
    boolean leftMouseButtonPressed = false;
    int lastOffsetX;
    int lastOffsetY;
    ColorScaleComposite colorScale = null;
    private ISelection selection;
    protected final List<ISelectionChangedListener> selectionChangedListeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private Rectangle polygonsBoundsRect = null;
    private static final int MARGIN = 10;
    private final MouseTrackHandler mouseTrackHandler = new MouseTrackHandler();
    private final MouseButtonHandler mouseButtonHandler = new MouseButtonHandler();
    private final MouseHoverHandler mouseHoverHandler = new MouseHoverHandler();
    private final KeyHandler keyHandler = new KeyHandler();
    protected Image canvasImage;
    private ISimulation simulation;
    private STEMTime time;
    private Sequencer sequencer;
    private DefaultToolTip tooltip;

    public MapCanvas(Composite parent, int style) {
        super(parent, 0x20040000);
        this.addPaintListener(this);
        this.addMouseWheelListener(this);
        this.addMouseTrackListener((MouseTrackListener)this.mouseTrackHandler);
        this.addMouseMoveListener(this);
        this.addKeyListener((KeyListener)this.keyHandler);
        this.addDisposeListener(this);
        this.addMouseListener((MouseListener)this.mouseButtonHandler);
        this.addMouseTrackListener((MouseTrackListener)this.mouseHoverHandler);
        this.tooltip = new DefaultToolTip((Control)this);
        this.tooltip.setHideDelay(30000);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point controlSize = ((Control)e.getSource()).getSize();
        this.toUpdateTranform = true;
        Image newCanvasImage = new Image((Device)e.display, controlSize.x, controlSize.y);
        GC localGC = new GC((Drawable)newCanvasImage);
        this.draw(localGC, 0, 0, controlSize.x, controlSize.y);
        localGC.dispose();
        gc.drawImage(newCanvasImage, 0, 0);
        Image oldCanvasImage = this.canvasImage;
        this.canvasImage = newCanvasImage;
        if (oldCanvasImage != null && !oldCanvasImage.isDisposed()) {
            oldCanvasImage.dispose();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.redraw();
    }

    public void saveCanvasImage(File path) throws IOException {
        try {
            if (this.canvasImage != null && !this.canvasImage.isDisposed()) {
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{this.canvasImage.getImageData()};
                loader.save(path.getAbsolutePath(), 5);
            }
        }
        catch (Exception e) {
            throw new IOException("MapCanvas:saveCanvasImage() Unable to save map canvas image to the file " + path.getAbsolutePath());
        }
    }

    public Image getCanvasImage() {
        return this.canvasImage;
    }

    public void mouseScrolled(MouseEvent e) {
        if (e.count >= 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.leftMouseButtonPressed) {
            int newX = e.x - this.lastOffsetX;
            int newY = e.y - this.lastOffsetY;
            this.lastOffsetX = e.x;
            this.lastOffsetY = e.y;
            if (newX != 0 || newY != 0) {
                this.addTranslation(newX, newY);
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    public void render(StemPolygonsList polygonsToRender, ISimulation sim) {
        this.simulation = sim;
        this.polygonsToRender = polygonsToRender;
        this.redraw();
    }

    public final void setDrawPolygonBorders(boolean drawPolygonBorders) {
        this.drawPolygonBorders = drawPolygonBorders;
    }

    public final void setGainFactor(float gainFactor) {
        this.gainFactor = gainFactor;
    }

    public final void setUseLogScaling(boolean useLogScaling) {
        this.useLogScaling = useLogScaling;
    }

    public void reset() {
        this.xTranslation = 0.0;
        this.yTranslation = 0.0;
        this.zoomFactor = 1.0;
    }

    void draw(GC gc, int x, int y, int width, int height) {
        gc.setBackground(this.stdColorProvider.getBackgroundColor());
        this.drawBackground(gc, x, y, width, height);
        gc.setLineWidth(0);
        if (this.polygonsToRender == null || this.polygonsToRender.isEmpty()) {
            return;
        }
        if (this.toUpdateTranform) {
            this.computeTransform(this.polygonsToRender);
            for (StemPolygon stempoly : this.polygonsToRender) {
                stempoly.setPointsTransformer(this.pointsTransformer);
            }
            this.toUpdateTranform = false;
        }
        Color bordersColor = this.stdColorProvider.getBordersColor();
        int bordersAlpha = this.stdColorProvider.getBordersAlpha();
        for (StemPolygon stempoly : this.polygonsToRender) {
            Identifiable identifiable = stempoly.getIdentifiable();
            if (identifiable instanceof Node) {
                this.colorProvider.setTarget((Notifier)identifiable);
                STEMColor color = this.colorProvider.getColor(this.gainFactor, this.useLogScaling);
                Color c = color.toSWTColor(gc.getDevice());
                Color back = this.stdColorProvider.getBackgroundColor();
                double alpha = color.getAlpha();
                int r = (int)(alpha * (double)c.getRed() + (1.0 - alpha) * (double)back.getRed());
                int g = (int)(alpha * (double)c.getGreen() + (1.0 - alpha) * (double)back.getGreen());
                int b = (int)(alpha * (double)c.getBlue() + (1.0 - alpha) * (double)back.getBlue());
                gc.setBackground(new Color(gc.getDevice(), r, g, b));
                gc.fillPolygon(stempoly.transformedPoints);
                if (this.drawPolygonBorders) {
                    gc.setForeground(bordersColor);
                    gc.setAlpha(bordersAlpha);
                    gc.drawPolygon(stempoly.transformedPoints);
                    gc.setAlpha(255);
                }
            }
            if (!(identifiable instanceof Edge)) continue;
            gc.setForeground(this.stdColorProvider.getEdgesColor());
            if (stempoly.transformedPoints == null) {
                stempoly.setPointsTransformer(this.pointsTransformer);
            }
            gc.drawLine(stempoly.transformedPoints[0], stempoly.transformedPoints[1], stempoly.transformedPoints[2], stempoly.transformedPoints[3]);
        }
        gc.setForeground(this.getDisplay().getSystemColor(2));
    }

    private void computeTransform(StemPolygonsList polygonList) {
        if (this.polygonsBoundsRect == null) {
            this.polygonsBoundsRect = polygonList.getBounds();
            if (this.polygonsBoundsRect == null) {
                return;
            }
        }
        Rectangle canvasBounds = this.getBounds();
        int effectiveCanvasWidth = canvasBounds.width - 20;
        int effectiveCanvasHeight = canvasBounds.height - 20;
        double width = this.polygonsBoundsRect.width;
        double height = this.polygonsBoundsRect.height;
        double WIDTH_RATIO = (double)effectiveCanvasWidth / width;
        double HEIGHT_RATIO = (double)effectiveCanvasHeight / height;
        double SCALE_FACTOR = Math.min(WIDTH_RATIO, HEIGHT_RATIO) * this.zoomFactor;
        int xCenteringTranslation = 0;
        int yCenteringTranslation = 0;
        if (width > 0.0 && height > 0.0) {
            xCenteringTranslation = (effectiveCanvasWidth - (int)(width * SCALE_FACTOR)) / 2;
            yCenteringTranslation = (effectiveCanvasHeight - (int)(height * SCALE_FACTOR)) / 2;
        }
        int boundsMinX = this.polygonsBoundsRect.x;
        int boundsMinY = this.polygonsBoundsRect.y;
        this.pointsTransformer.setOffsetX((double)(-boundsMinX) * SCALE_FACTOR + 10.0 + (double)xCenteringTranslation + this.xTranslation * this.zoomFactor);
        this.pointsTransformer.setOffsetY((double)(-boundsMinY) * SCALE_FACTOR + 10.0 + (double)yCenteringTranslation + this.yTranslation * this.zoomFactor);
        this.pointsTransformer.setScale(SCALE_FACTOR);
    }

    void zoomIn() {
        this.zoomFactor *= 1.1;
        this.toUpdateTranform = true;
        this.redraw();
    }

    void zoomOut() {
        this.zoomFactor *= 0.9090909090909091;
        this.toUpdateTranform = true;
        this.redraw();
    }

    StemPolygon getPolygon(MouseEvent e) {
        Point latLongPosition = this.pointsTransformer.getInversedPoint(e.x, e.y);
        return this.getPolygon(latLongPosition);
    }

    StemPolygon getPolygon(Point point) {
        StemPolygon retValue = null;
        if (point != null && this.polygonsToRender != null) {
            retValue = this.polygonsToRender.getContainingRegionPolygon(point);
        }
        return retValue;
    }

    protected void addTranslation(double xTranslationAddition, double yTranslationAddition) {
        this.xTranslation += xTranslationAddition / this.zoomFactor;
        this.yTranslation += yTranslationAddition / this.zoomFactor;
        this.toUpdateTranform = true;
        this.redraw();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    public void setColorProvider(ColorProviderAdapter colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void dispose() {
        this.tooltip = null;
        this.removePaintListener(this);
        this.removeMouseWheelListener(this);
        this.removeMouseTrackListener((MouseTrackListener)this.mouseTrackHandler);
        this.removeMouseMoveListener(this);
        this.removeKeyListener((KeyListener)this.keyHandler);
        this.removeDisposeListener(this);
        this.removeMouseListener((MouseListener)this.mouseButtonHandler);
        this.removeMouseTrackListener((MouseTrackListener)this.mouseHoverHandler);
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    MapCanvas.this.zoomIn();
                    break;
                }
                case 0x1000002: {
                    MapCanvas.this.zoomOut();
                    break;
                }
            }
        }
    }

    protected class MouseButtonHandler
    extends MouseAdapter {
        protected MouseButtonHandler() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                MapCanvas.this.lastOffsetX = e.x;
                MapCanvas.this.lastOffsetY = e.y;
                MapCanvas.this.leftMouseButtonPressed = true;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1) {
                int newX = e.x - MapCanvas.this.lastOffsetX;
                int newY = e.y - MapCanvas.this.lastOffsetY;
                if (newX != 0 || newY != 0) {
                    MapCanvas.this.addTranslation(newX, newY);
                } else {
                    StemPolygon polygon = MapCanvas.this.getPolygon(e);
                    if (polygon != null) {
                        GeographicSelectionElements gse = new GeographicSelectionElements();
                        Point latLongPosition = MapCanvas.this.pointsTransformer.getInversedPoint(e.x, e.y);
                        double longitude = polygon.unScaleLongitude(latLongPosition.x);
                        double latitude = polygon.unScaleLatitude(latLongPosition.y);
                        gse.setPoint(longitude, latitude);
                        Identifiable regnImpl = polygon.getIdentifiable();
                        Object[] elements = new Object[]{regnImpl, gse};
                        StructuredSelection selection = new StructuredSelection(elements);
                        MapCanvas.this.fireSelection((ISelection)selection);
                    }
                }
                MapCanvas.this.leftMouseButtonPressed = false;
            }
            SelectedReportsManager.getInstance().setRecentClickedMapCanvas((MapCanvas)((Object)e.getSource()));
        }
    }

    protected class MouseHoverHandler
    extends MouseTrackAdapter {
        protected MouseHoverHandler() {
        }

        public void mouseHover(MouseEvent e) {
            Point latLongPosition = MapCanvas.this.pointsTransformer.getInversedPoint(e.x, e.y);
            StemPolygon polygon = MapCanvas.this.getPolygon(latLongPosition);
            if (polygon != null) {
                Identifiable identifiable = polygon.getIdentifiable();
                DublinCore dc = identifiable.getDublinCore();
                String dcIdentifier = dc.getIdentifier();
                String isoKey = dcIdentifier.substring(dcIdentifier.lastIndexOf("/") + 1);
                String toolTipText = null;
                if (isoKey != null && !isoKey.equals("")) {
                    String geographicName = GeographicNames.getName((String)isoKey);
                    boolean retry = true;
                    StringBuilder sb = null;
                    while (retry) {
                        retry = false;
                        try {
                            sb = new StringBuilder(geographicName);
                            sb.append(" (");
                            sb.append(isoKey);
                            sb.append(")");
                            Region region = (Region)identifiable;
                            for (NodeLabel nextLabel : region.getLabels()) {
                                if (nextLabel instanceof PopulationModelLabel) {
                                    sb.append("\nPopulation (now): " + nextLabel);
                                }
                                if (nextLabel instanceof PopulationLabel) {
                                    sb.append("\nPopulation (" + ((PopulationLabel)nextLabel).getValidYear() + "):" + nextLabel);
                                }
                                if (nextLabel instanceof AreaLabel) {
                                    sb.append("\nArea: " + nextLabel);
                                }
                                if (!(nextLabel instanceof StandardDiseaseModelLabel)) continue;
                                sb.append("\n" + ((StandardDiseaseModelLabel)nextLabel).toTooltipString());
                            }
                            if (latLongPosition != null) {
                                double latitude = -1.0 * StemPolygon.getUnscaledLatitude(latLongPosition.y);
                                double longitude = -1.0 * StemPolygon.getUnscaledLongitude(latLongPosition.x);
                                sb.append("\nLatitude: " + latitude + ", Longitude: " + longitude);
                            }
                            MapCanvas.this.sequencer = MapCanvas.this.simulation.getScenario().getSequencer();
                            MapCanvas.this.time = MapCanvas.this.sequencer.getCurrentTime();
                            sb.append("\nTime: " + MapCanvas.this.time.toString());
                        }
                        catch (ConcurrentModificationException cme) {
                            retry = true;
                        }
                    }
                    toolTipText = sb.toString();
                } else {
                    toolTipText = polygon.getTitle();
                }
                if (MapCanvas.this.tooltip != null) {
                    if (toolTipText != null) {
                        MapCanvas.this.tooltip.setText(toolTipText);
                        MapCanvas.this.tooltip.show(new Point(e.x, e.y));
                    } else {
                        MapCanvas.this.tooltip.hide();
                    }
                }
            } else if (MapCanvas.this.tooltip != null) {
                MapCanvas.this.tooltip.hide();
            }
        }
    }

    protected static class MouseTrackHandler
    extends MouseTrackAdapter {
        protected MouseTrackHandler() {
        }

        public void mouseEnter(MouseEvent e) {
        }
    }
}

