/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;

public class SIRLabelValueImpl
extends SILabelValueImpl
implements SIRLabelValue {
    protected static final double R_EDEFAULT = 0.0;
    protected double r = 0.0;

    public SIRLabelValueImpl() {
    }

    public SIRLabelValueImpl(double s, double i, double incidence, double r, double diseaseDeaths) {
        super(s, i, incidence, diseaseDeaths);
        this.setR(r);
    }

    public SIRLabelValueImpl(double s, double i, double r, double diseaseDeaths) {
        super(s, i, 0.0, diseaseDeaths);
        this.setR(r);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR_LABEL_VALUE;
    }

    @Override
    public double getR() {
        return this.r;
    }

    @Override
    public void setR(double newR) {
        this.r = newR;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getR();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setR((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setR(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.r != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (r: ");
        result.append(this.r);
        result.append(')');
        return result.toString();
    }

    @Override
    public IntegrationLabelValue set(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        super.set(value);
        this.setR(v.getR());
        return this;
    }

    @Override
    public IntegrationLabelValue add(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        super.add(value);
        this.setR(this.getR() + v.getR());
        return this;
    }

    @Override
    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        super.sub(value);
        this.setR(this.getR() - v.getR());
        return this;
    }

    @Override
    public IntegrationLabelValue scale(double scaleFactor) {
        super.scale(scaleFactor);
        this.setR(scaleFactor * this.getR());
        return this;
    }

    @Override
    public IntegrationLabelValue add(double addition) {
        super.add(addition);
        this.setR(this.getR() + addition);
        return this;
    }

    @Override
    public IntegrationLabelValue abs() {
        super.abs();
        this.setR(Math.abs(this.getR()));
        return this;
    }

    @Override
    public boolean avoidNegative(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        boolean adjusted = super.avoidNegative(value);
        if (this.getR() + v.getR() < 0.0) {
            this.setR(-v.getR());
        }
        return adjusted;
    }

    @Override
    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        double factor = super.computeDeltaAdjustment(value);
        if (this.getR() + v.getR() < 0.0) {
            factor = Math.min(factor, -v.getR() / this.getR());
        }
        return factor;
    }

    @Override
    public IntegrationLabelValue divide(IntegrationLabelValue value) {
        SIRLabelValue v = (SIRLabelValue)value;
        super.divide(value);
        this.setR(this.getR() / v.getR());
        return this;
    }

    @Override
    public double max() {
        double max = super.max();
        max = Math.max(max, this.getR());
        return max;
    }

    @Override
    public void reset() {
        super.reset();
        this.setR(0.0);
    }

    @Override
    public boolean sameValue(LabelValue otherLabelValue) {
        SIRLabelValue v = (SIRLabelValue)otherLabelValue;
        if (!super.sameValue(otherLabelValue)) {
            return false;
        }
        return this.getR() == v.getR();
    }

    @Override
    public double getPopulationCount() {
        return super.getPopulationCount() + this.getR();
    }

    @Override
    public IntegrationLabelValue copy() {
        SIRLabelValue ilv = StandardFactory.eINSTANCE.createSIRLabelValue();
        ilv.set(this);
        return ilv;
    }

    @Override
    public void eSetDouble(int featureId, double newValue) {
        switch (featureId) {
            case 7: {
                this.setR(newValue);
                return;
            }
        }
        super.eSetDouble(featureId, newValue);
    }

    @Override
    public double eGetDouble(int featureId) {
        switch (featureId) {
            case 7: {
                return this.getR();
            }
        }
        return super.eGetDouble(featureId);
    }
}

