/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class RemoveUnknownExecEnvironments
extends AbstractManifestMarkerResolution {
    public RemoveUnknownExecEnvironments(int type) {
        super(type);
    }

    protected void createChange(BundleModel model) {
        IManifestHeader header = model.getBundle().getManifestHeader("Bundle-RequiredExecutionEnvironment");
        if (header instanceof RequiredExecutionEnvironmentHeader) {
            RequiredExecutionEnvironmentHeader reqHeader = (RequiredExecutionEnvironmentHeader)header;
            ExecutionEnvironment[] bundleEnvs = reqHeader.getEnvironments();
            IExecutionEnvironment[] systemEnvs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            int i = 0;
            while (i < bundleEnvs.length) {
                boolean found = false;
                int j = 0;
                while (j < systemEnvs.length) {
                    if (bundleEnvs[i].getName().equals(systemEnvs[j].getId())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    reqHeader.removeExecutionEnvironment(bundleEnvs[i]);
                }
                ++i;
            }
        }
    }

    public String getLabel() {
        return PDEUIMessages.RemoveUnknownExecEnvironments_label;
    }
}

