/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.SimpleFormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.shared.target.ArgumentsFromContainerSelectionDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ArgumentsSection
extends SectionPart {
    private CTabFolder fTabFolder;
    private FormEntry fProgramArguments;
    private FormEntry fVMArguments;
    private Image fImage;
    private TargetEditor fEditor;

    public ArgumentsSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.fImage = PDEPluginImages.DESC_ARGUMENT_TAB.createImage();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.ArgumentsSection_editorTitle);
        section.setDescription(PDEUIMessages.ArgumentsSection_description);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        client.setLayoutData((Object)gd);
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        gd = new GridData(1808);
        this.fTabFolder.setLayoutData((Object)gd);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        Composite programComp = toolkit.createComposite((Composite)this.fTabFolder);
        programComp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        programComp.setLayoutData((Object)new GridData(1808));
        this.fProgramArguments = new FormEntry(programComp, toolkit, PDEUIMessages.ArgumentsSection_0, 66);
        this.fProgramArguments.getText().setLayoutData((Object)new GridData(1808));
        this.fProgramArguments.setFormEntryListener(new SimpleFormEntryAdapter((AbstractFormPart)this){

            public void textValueChanged(FormEntry entry) {
                String value = entry.getValue().trim();
                ArgumentsSection.this.getTarget().setProgramArguments(value.length() > 0 ? value : null);
            }
        });
        Button variables = toolkit.createButton(programComp, PDEUIMessages.ArgumentsSection_variableButtonTitle, 0);
        variables.setLayoutData((Object)new GridData(128));
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsSection.this.getSection().getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ArgumentsSection.this.fProgramArguments.getText().insert(variable);
                }
            }
        });
        CTabItem programTab = new CTabItem(this.fTabFolder, 0);
        programTab.setText(PDEUIMessages.ArgumentsSection_programTabLabel);
        programTab.setImage(this.fImage);
        programTab.setControl((Control)programComp);
        toolkit.paintBordersFor(programComp);
        Composite vmComp = toolkit.createComposite((Composite)this.fTabFolder);
        vmComp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        vmComp.setLayoutData((Object)new GridData(1808));
        this.fVMArguments = new FormEntry(vmComp, toolkit, PDEUIMessages.ArgumentsSection_1, 66);
        this.fVMArguments.getText().setLayoutData((Object)new GridData(1808));
        this.fVMArguments.setFormEntryListener(new SimpleFormEntryAdapter((AbstractFormPart)this){

            public void textValueChanged(FormEntry entry) {
                String value = entry.getValue().trim();
                ArgumentsSection.this.getTarget().setVMArguments(value.length() > 0 ? value : null);
            }
        });
        Composite buttons = new Composite(vmComp, 0);
        GridLayout layout = FormLayoutFactory.createSectionClientGridLayout(false, 2);
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(128));
        Button vmArgs = toolkit.createButton(buttons, PDEUIMessages.ArgumentsSection_argumentsButtonTitle, 0);
        vmArgs.setLayoutData((Object)new GridData(128));
        vmArgs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] args;
                ArgumentsFromContainerSelectionDialog dialog = new ArgumentsFromContainerSelectionDialog(ArgumentsSection.this.getSection().getShell(), ArgumentsSection.this.getTarget());
                if (dialog.open() == 0 && (args = dialog.getSelectedArguments()) != null && args.length > 0) {
                    StringBuffer resultBuffer = new StringBuffer();
                    int index = 0;
                    while (index < args.length) {
                        resultBuffer.append(String.valueOf(args[index]) + " ");
                        ++index;
                    }
                    ArgumentsSection.this.fVMArguments.getText().insert(resultBuffer.toString());
                }
            }
        });
        variables = toolkit.createButton(buttons, PDEUIMessages.ArgumentsSection_variableButtonTitle, 0);
        variables.setLayoutData((Object)new GridData(128));
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsSection.this.getSection().getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ArgumentsSection.this.fVMArguments.getText().insert(variable);
                }
            }
        });
        CTabItem vmTab = new CTabItem(this.fTabFolder, 0);
        vmTab.setText(PDEUIMessages.ArgumentsSection_vmTabLabel);
        vmTab.setImage(this.fImage);
        vmTab.setControl((Control)vmComp);
        toolkit.paintBordersFor(vmComp);
        this.fTabFolder.setSelection(programTab);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    public void refresh() {
        this.fProgramArguments.setValue(this.getTarget().getProgramArguments(), true);
        this.fVMArguments.setValue(this.getTarget().getVMArguments(), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fProgramArguments.commit();
        this.fVMArguments.commit();
        super.commit(onSave);
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        super.dispose();
    }
}

