/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.Date;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

public class ScaleContext
extends Methods {
    private Object oMinAuto;
    private Object oMaxAuto;
    private Object oMinFixed;
    private Object oMaxFixed;
    private Integer oStepNumber;
    private final int iMarginPercent;
    private final int iType;
    private Object oUnit;
    private Object oMin;
    private Object oMax;
    private Object oStep;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private boolean bMargin = false;
    private boolean bExpandMinmax = true;

    public ScaleContext copy() {
        ScaleContext dest = new ScaleContext(this.iMarginPercent, this.iType);
        dest.oMinAuto = this.oMinAuto;
        dest.oMaxAuto = this.oMaxAuto;
        dest.oMinFixed = this.oMinFixed;
        dest.oMaxFixed = this.oMaxFixed;
        dest.oStepNumber = this.oStepNumber;
        dest.oUnit = this.oUnit;
        dest.oMin = this.oMin;
        dest.oMax = this.oMax;
        dest.oStep = this.oStep;
        dest.bMinimumFixed = this.bMinimumFixed;
        dest.bMaximumFixed = this.bMaximumFixed;
        dest.bStepFixed = this.bStepFixed;
        dest.bMargin = this.bMargin;
        dest.bExpandMinmax = this.bExpandMinmax;
        return dest;
    }

    public ScaleContext(int iMarginPercent, int iType) {
        this.iMarginPercent = iMarginPercent;
        this.iType = iType;
    }

    public ScaleContext(int iMarginPercent, int iType, Object oUnit, Object oMinValue, Object oMaxValue, Object oStep) {
        this.iMarginPercent = iMarginPercent;
        this.iType = iType;
        this.oUnit = oUnit;
        this.oMinAuto = oMinValue;
        this.oMaxAuto = oMaxValue;
        this.oStep = oStep;
        this.bMargin = iMarginPercent > 0;
    }

    public ScaleContext(int iMarginPercent, int iType, Object oMinAuto, Object oMaxAuto, Object oStep) {
        this(iMarginPercent, iType, 0, oMinAuto, oMaxAuto, oStep);
    }

    public void updateShared(ScaleContext that) {
        this.oUnit = that.oUnit;
        this.oStep = that.oStep;
    }

    public static ScaleContext createSimpleScale(Object oMin, Object oMax) {
        ScaleContext scale = new ScaleContext(0, 0, oMin, oMax, null);
        if (oMin instanceof Date) {
            scale.oMin = new CDateTime((Date)oMin);
            scale.oMax = new CDateTime((Date)oMax);
        } else {
            scale.oMin = oMin;
            scale.oMax = oMax;
        }
        return scale;
    }

    public void setFixedValue(boolean bMinimumFixed, boolean bMaximumFixed, Object oMinFixed, Object oMaxFixed) {
        this.oMinFixed = oMinFixed;
        this.oMaxFixed = oMaxFixed;
        this.bMinimumFixed = bMinimumFixed;
        this.bMaximumFixed = bMaximumFixed;
        this.oMin = oMinFixed;
        this.oMax = oMaxFixed;
    }

    public void setFixedStep(boolean bStepFixed, Integer oStepNumber) {
        this.oStepNumber = oStepNumber;
        this.bStepFixed = bStepFixed || oStepNumber != null;
    }

    public Object getMin() {
        return this.oMin;
    }

    public void setMin(Object oMin) {
        this.oMin = oMin;
    }

    public Object getMax() {
        return this.oMax;
    }

    public void setMax(Object oMax) {
        this.oMax = oMax;
    }

    public Object getMinWithMargin() {
        return this.oMinAuto;
    }

    public void setMinWithMargin(Object oMinAuto) {
        this.oMinAuto = oMinAuto;
    }

    public Object getMaxWithMargin() {
        return this.oMaxAuto;
    }

    public void setMaxWithMargin(Object oMaxAuto) {
        this.oMaxAuto = oMaxAuto;
    }

    public Object getStep() {
        return this.oStep;
    }

    public void setStep(Object oStep) {
        this.oStep = oStep;
    }

    public Integer getStepNumber() {
        return this.oStepNumber;
    }

    public void setStepNumber(Integer oStepNumber) {
        this.oStepNumber = oStepNumber;
    }

    public void computeMinMax() {
        this.computeMinMax(false);
    }

    public void computeMinMax(boolean bAlignZero) {
        if ((this.iType & 2) == 2) {
            this.computeLinearMinMax(bAlignZero);
        } else if ((this.iType & 8) == 8) {
            this.computeDateTimeMinMax();
        } else if ((this.iType & 4) == 4) {
            this.computeLogMinMax();
        }
    }

    private void computeLinearMinMax(boolean bAlignZero) {
        double dMaxValue;
        double dMargin = 0.0;
        if (this.bMargin) {
            dMargin = Math.abs(ScaleContext.asDouble(this.oMaxAuto) - ScaleContext.asDouble(this.oMinAuto)) * (double)this.iMarginPercent / 100.0;
        }
        double dMinReal = ScaleContext.asDouble(this.oMinAuto) - dMargin;
        double dMaxReal = ScaleContext.asDouble(this.oMaxAuto) + dMargin;
        double dMinValue = this.bMinimumFixed ? ScaleContext.asDouble(this.oMinFixed) : dMinReal;
        double d = dMaxValue = this.bMaximumFixed ? ScaleContext.asDouble(this.oMaxFixed) : dMaxReal;
        if (dMaxValue < dMinValue) {
            if (this.bMaximumFixed && dMaxValue >= 0.0) {
                dMinValue = 0.0;
            }
            if (this.bMinimumFixed && dMinValue <= 0.0) {
                dMaxValue = 0.0;
            }
        }
        double dMinAxis = dMinValue;
        double dMaxAxis = dMaxValue;
        double dStep = 0.0;
        if (this.bStepFixed && this.oStepNumber != null) {
            this.oStep = new Double(Math.abs(dMaxValue - dMinValue) / (double)this.oStepNumber.intValue());
        } else {
            dStep = ScaleContext.asDouble(this.oStep);
            if (this.bMargin) {
                dMinAxis = (dStep >= 1.0 ? Math.floor(dMinAxis / dStep) : (double)Math.round(dMinAxis / dStep)) * dStep;
                dMaxAxis = ((dStep >= 1.0 ? Math.floor(dMaxAxis / dStep) : (double)Math.round(dMaxAxis / dStep)) + 1.0) * dStep;
                if (dMaxAxis - dMaxValue >= dStep) {
                    dMaxAxis -= dStep;
                }
            } else if (!this.bExpandMinmax) {
                double dMinAxis1 = (dStep >= 1.0 ? Math.floor(dMinAxis / dStep) : (double)Math.round(dMinAxis / dStep)) * dStep;
                dMinAxis = dMinAxis < dMinAxis1 ? dMinAxis1 - dStep : dMinAxis1;
                double dMaxAxis1 = (dStep >= 1.0 ? Math.floor(dMaxAxis / dStep) : (double)Math.round(dMaxAxis / dStep)) * dStep;
                dMaxAxis = dMaxAxis > dMaxAxis1 ? dMaxAxis1 + dStep : dMaxAxis1;
            } else {
                double dAbsMax = Math.abs(dMaxValue);
                double dAbsMin = Math.abs(dMinValue);
                dMinAxis = (dStep >= 1.0 ? Math.floor(dAbsMin / dStep) : (double)Math.round(dAbsMin / dStep)) * dStep;
                dMaxAxis = (dStep >= 1.0 ? Math.floor(dAbsMax / dStep) : (double)Math.round(dAbsMax / dStep)) * dStep;
                if (ChartUtil.mathEqual(dMinAxis, dAbsMin)) {
                    dMinAxis += dStep;
                    if (dMinValue < 0.0) {
                        dMinAxis = -dMinAxis;
                    } else if (dMinValue == 0.0) {
                        dMinAxis = 0.0;
                    }
                } else if (dMinValue < 0.0) {
                    dMinAxis = -(dMinAxis + dStep);
                } else if (dMinAxis >= dMinValue && dMinAxis != 0.0) {
                    dMinAxis -= dStep;
                }
                if (ChartUtil.mathEqual(dMaxAxis, dAbsMax)) {
                    dMaxAxis += dStep;
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -dMaxAxis;
                    } else if (dMaxValue == 0.0) {
                        dMaxAxis = 0.0;
                    }
                } else if (!ChartUtil.mathEqual(dMinAxis, dMaxValue)) {
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -(dMaxAxis - dStep);
                    } else if (dMaxValue > 0.0 && dMaxAxis < dMaxValue) {
                        dMaxAxis += dStep;
                    }
                    if (dMaxAxis - dMaxValue < (dMaxAxis - dMinAxis) / 30.0) {
                        dMaxAxis += dStep;
                    }
                }
                if (dMinValue < 0.0 && dMaxValue < 0.0 && dMaxAxis <= dMaxValue - dStep) {
                    dMaxAxis += 2.0 * dStep;
                }
                if (dMinValue > 0.0 && dMaxValue > 0.0 && dMinAxis >= dMinValue + dStep) {
                    dMinAxis -= 2.0 * dStep;
                }
                if (dMaxAxis - dMaxValue < (dMaxAxis - dMinAxis) / 50.0) {
                    dMaxAxis += dStep;
                }
            }
        }
        if (dMinValue == 0.0 && dMaxValue == 0.0) {
            if (dMinAxis >= 0.0) {
                dMinAxis = -1.0;
            }
            if (dMaxAxis <= 0.0) {
                dMaxAxis = 1.0;
            }
        }
        if ((this.iType & 0x20) == 32) {
            if (dMaxAxis > 0.0) {
                dMaxAxis = 100.0;
            }
            if (dMinAxis < 0.0) {
                dMinAxis = -100.0;
            }
        }
        if (bAlignZero && dMinAxis < 0.0 && dMaxAxis > 0.0) {
            double abs = Math.max(Math.abs(dMinAxis), Math.abs(dMaxAxis));
            dMinAxis = -abs;
            dMaxAxis = abs;
        }
        if (!this.bMaximumFixed) {
            this.oMax = new Double(dMaxAxis);
        }
        if (!this.bMinimumFixed) {
            this.oMin = new Double(dMinAxis);
        }
        if (this.bMargin) {
            this.oMinAuto = this.bMinimumFixed && dMinValue > dMinReal ? new Double(dMinReal) : null;
            this.oMaxAuto = this.bMaximumFixed && dMaxValue < dMaxReal ? new Double(dMaxReal) : null;
        } else {
            this.oMinAuto = null;
            this.oMaxAuto = null;
        }
    }

    private void computeDateTimeMinMax() {
        int iStep = ScaleContext.asInteger(this.oStep);
        CDateTime cdtMinValue = this.bMinimumFixed ? ScaleContext.asDateTime(this.oMinFixed) : ScaleContext.asDateTime(this.oMinAuto);
        CDateTime cdtMaxValue = this.bMaximumFixed ? ScaleContext.asDateTime(this.oMaxFixed) : ScaleContext.asDateTime(this.oMaxAuto);
        int iUnit = (Integer)this.oUnit;
        if (this.bMaximumFixed && !this.bMinimumFixed) {
            this.oMax = cdtMaxValue;
            double diff = CDateTime.computeDifference(cdtMaxValue, cdtMinValue, iUnit) / (double)iStep;
            int count = (int)diff * iStep;
            if (!ChartUtil.mathEqual(diff, Math.floor(diff))) {
                count += iStep;
            }
            CDateTime cdtMinValue_new = (CDateTime)((Object)cdtMaxValue.clone());
            cdtMinValue_new.add(iUnit, -count);
            this.oMin = cdtMinValue_new;
        } else {
            if (this.bExpandMinmax) {
                if (!this.bMinimumFixed) {
                    cdtMinValue = cdtMinValue.backward(iUnit, iStep);
                    cdtMinValue.clearBelow(iUnit);
                    if (!this.bMaximumFixed) {
                        cdtMaxValue = cdtMaxValue.forward(iUnit, 1);
                        cdtMaxValue.clearBelow(iUnit);
                    }
                } else if (!this.bMaximumFixed) {
                    double diff = CDateTime.computeDifference(cdtMaxValue, cdtMinValue, iUnit) / (double)iStep;
                    int count = (int)diff * iStep;
                    if (!ChartUtil.mathEqual(diff, Math.floor(diff))) {
                        count += iStep;
                    }
                    CDateTime cdtMaxValue_new = (CDateTime)((Object)cdtMinValue.clone());
                    cdtMaxValue_new.add(iUnit, count);
                    cdtMaxValue = cdtMaxValue_new;
                }
            }
            this.oMin = cdtMinValue;
            this.oMax = cdtMaxValue;
        }
        this.oMinAuto = null;
        this.oMaxAuto = null;
    }

    private void computeLogMinMax() {
        double dMinValue = ScaleContext.asDouble(this.oMinAuto);
        double dMaxValue = ScaleContext.asDouble(this.oMaxAuto);
        double dAbsMax = Math.abs(dMaxValue);
        double dAbsMin = Math.abs(dMinValue);
        double dStep = ScaleContext.asDouble(this.oStep);
        double dStepLog = Math.log(dStep);
        int iPow = (int)Math.floor(Math.log(dAbsMax) / dStepLog) + 1;
        double dMaxAxis = Math.pow(dStep, iPow);
        iPow = (int)Math.floor(Math.log(dAbsMin) / dStepLog) - 1;
        double dMinAxis = Math.pow(dStep, iPow + 1);
        if (!this.bMaximumFixed) {
            this.oMax = new Double(dMaxAxis);
        }
        if (!this.bMinimumFixed) {
            this.oMin = new Double(dMinAxis);
        }
        this.oMinAuto = null;
        this.oMaxAuto = null;
    }

    public Object getUnit() {
        return this.oUnit;
    }

    public void setUnit(Object oUnit) {
        this.oUnit = oUnit;
    }

    public boolean isExpandMinmax() {
        return this.bExpandMinmax;
    }

    public void setExpandMinmax(boolean expandMinmax) {
        this.bExpandMinmax = expandMinmax;
    }
}

