/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;

public abstract class WildcardType
extends TType {
    protected TType fBound;

    protected WildcardType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding) {
        Assert.isTrue((boolean)binding.isWildcardType());
        super.initialize(binding);
        ITypeBinding bound = binding.getBound();
        if (bound != null) {
            this.fBound = this.getEnvironment().create(bound);
        }
    }

    public TType getBound() {
        return this.fBound;
    }

    public TType[] getSubTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean doEquals(TType type) {
        WildcardType other = (WildcardType)type;
        if (this.fBound == null) {
            return other.fBound == null;
        }
        return this.fBound.equals(other.fBound);
    }

    public int hashCode() {
        if (this.fBound == null) {
            return 123;
        }
        return this.fBound.hashCode() << 3;
    }

    protected abstract boolean checkAssignmentBound(TType var1);

    protected String internalGetName(String keyword) {
        StringBuffer result = new StringBuffer("?");
        TType bound = this.getBound();
        if (bound != null) {
            result.append(" ");
            result.append(keyword);
            result.append(" ");
            result.append(bound.getName());
        }
        return result.toString();
    }

    protected String internalGetPrettySignature(String keyword) {
        StringBuffer result = new StringBuffer("?");
        TType bound = this.getBound();
        if (bound != null) {
            result.append(" ");
            result.append(keyword);
            result.append(" ");
            result.append(bound.getPlainPrettySignature());
        }
        return result.toString();
    }
}

