/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedCodeCleanUp
extends AbstractMultiFix {
    public UnusedCodeCleanUp(Map<String, String> options) {
        super(options);
    }

    public UnusedCodeCleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods") || removeUnuseMembers && this.isEnabled("cleanup.remove_private_constructors") || removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields") || removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_local_variables") || this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeUnuseMembers && this.isEnabled("cleanup.remove_private_constructors"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        boolean removeMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, removeMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeMembers && this.isEnabled("cleanup.remove_private_constructors"), removeMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    public Map<String, String> getRequiredOptions() {
        boolean removeMembers;
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        }
        if ((removeMembers = this.isEnabled("cleanup.remove_unused_private_members")) && (this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_private_types"))) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unused_imports")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedImport_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedConstructor_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedType_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (!this.isEnabled("cleanup.remove_unused_imports")) {
            buf.append("import pack.Bar;\n");
        }
        buf.append("class Example {\n");
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_types")) {
            buf.append("    private class Sub {}\n");
        }
        buf.append("    public Example(boolean b) {}\n");
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_private_constructors")) {
            buf.append("    private Example() {}\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_fields")) {
            buf.append("    private int fField;\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_methods")) {
            buf.append("    private void foo() {}\n");
        }
        buf.append("    public void bar() {\n");
        if (!this.isEnabled("cleanup.remove_unused_local_variables")) {
            buf.append("        int i= 10;\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (UnusedCodeFix.isUnusedImport(problem)) {
            return this.isEnabled("cleanup.remove_unused_imports");
        }
        if (UnusedCodeFix.isUnusedMember(problem)) {
            return this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            int i = 0;
            while (i < problems.length) {
                int id = problems[i].getID();
                if (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result += UnusedCodeCleanUp.getNumberOfProblems(problems, 603979894);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            result += UnusedCodeCleanUp.getNumberOfProblems(problems, 603979910);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            result += UnusedCodeCleanUp.getNumberOfProblems(problems, 553648135);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result += UnusedCodeCleanUp.getNumberOfProblems(problems, 570425421);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result += UnusedCodeCleanUp.getNumberOfProblems(problems, 536870973);
        }
        return result;
    }
}

