/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordBasedValueConverter
extends AbstractValueConverter<String>
implements IValueConverter.RuleSpecific {
    private Set<String> keywords;
    private AbstractRule rule;

    @Override
    public String toValue(String string, INode node) throws ValueConverterException {
        return string;
    }

    @Override
    public String toString(String value) throws ValueConverterException {
        this.assertValidValue(value);
        String result = this.toEscapedString(value);
        return result;
    }

    protected void assertValidValue(String value) {
        if (!this.keywords.contains(value)) {
            throw new ValueConverterException("The value '" + value + "' is an invalid " + this.rule.getName(), null, null);
        }
    }

    protected String toEscapedString(String value) {
        return value;
    }

    protected String keywordToString(Keyword keyword) {
        return keyword.getValue();
    }

    @Override
    public void setRule(AbstractRule rule) {
        this.rule = rule;
        if (!GrammarUtil.isDatatypeRule(rule)) {
            throw new IllegalArgumentException(String.valueOf(rule.getName()) + " is not a data type rule");
        }
        if (!(rule.getAlternatives() instanceof Alternatives) && !(rule.getAlternatives() instanceof Keyword)) {
            throw new IllegalArgumentException(String.valueOf(rule.getName()) + " is not a simple keyword nor an alternative");
        }
        if (rule.getAlternatives() instanceof Keyword) {
            this.keywords = ImmutableSet.of((Object)this.keywordToString((Keyword)rule.getAlternatives()));
        } else {
            Alternatives alternatives = (Alternatives)rule.getAlternatives();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AbstractElement element : alternatives.getElements()) {
                if (!(element instanceof Keyword)) {
                    throw new IllegalArgumentException(String.valueOf(rule.getName()) + "'s body does not contain an alternative of keywords");
                }
                builder.add((Object)this.keywordToString((Keyword)element));
            }
            this.keywords = builder.build();
        }
    }
}

