/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

public class CSVAnalysisWriter {
    private String outputFileName = "";
    protected String paramFileName;
    private static final IPath PATH = Activator.getDefault().getStateLocation();
    private static final String sep = File.separator;
    protected static final String CSV = "csv";
    private static final String PATH_SUFFIX = "csv" + sep;
    private static String adir = PATH.append(String.valueOf(sep) + PATH_SUFFIX).toOSString();
    private FileWriter fw;

    public CSVAnalysisWriter(String fileName) {
        boolean success;
        this.outputFileName = String.valueOf(adir) + fileName + "." + CSV;
        File dir = new File(adir);
        if (!(dir.exists() && dir.isDirectory() || (success = dir.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.outputFileName, new IOException("Failed to Create Driectory" + this.outputFileName));
        }
        try {
            this.fw = new FileWriter(this.outputFileName);
        }
        catch (IOException e) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, e);
        }
    }

    public CSVAnalysisWriter(String directory, String fileName) {
        boolean success;
        adir = directory;
        this.outputFileName = String.valueOf(adir) + fileName + "." + CSV;
        File dir = new File(adir);
        if (!(dir.exists() && dir.isDirectory() || (success = dir.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.outputFileName, new IOException("Failed to Create Driectory" + this.outputFileName));
        }
        try {
            this.fw = new FileWriter(this.outputFileName);
        }
        catch (IOException e) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, e);
        }
    }

    public void logData(List<EList<Double>> dataList) {
        int maxRows = 0;
        int numArrays = dataList.size();
        int i = 0;
        while (i < numArrays) {
            EList<Double> data = dataList.get(i);
            if (data.size() >= maxRows) {
                maxRows = data.size();
            }
            ++i;
        }
        int y = 0;
        while (y < maxRows) {
            StringBuilder strBldr = new StringBuilder();
            int x = 0;
            while (x < numArrays) {
                EList<Double> data = dataList.get(x);
                if (data.size() >= maxRows) {
                    strBldr.append(data.get(y));
                    if (x < numArrays - 1) {
                        strBldr.append(", ");
                    }
                }
                ++x;
            }
            strBldr.append("\n");
            try {
                this.fw.write(strBldr.toString());
            }
            catch (IOException e) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, e);
            }
            ++y;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException e) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, e);
        }
    }

    public void logData(List<String> header, List<double[]> dataList) {
        String strHeader = "iteration";
        StringBuilder strBldr = new StringBuilder(strHeader);
        int x = 0;
        while (x < header.size()) {
            strBldr.append(", ");
            strBldr.append(header.get(x));
            ++x;
        }
        strBldr.append("\n");
        try {
            this.fw.write(strBldr.toString());
        }
        catch (IOException e) {
            Activator.logError("Error writing HEADER to CSV Analysis file" + this.outputFileName + this.outputFileName, e);
        }
        int maxRows = 0;
        int numArrays = dataList.size();
        int i = 0;
        while (i < numArrays) {
            double[] data = dataList.get(i);
            if (data.length >= maxRows) {
                maxRows = data.length;
            }
            ++i;
        }
        int y = 0;
        while (y < maxRows) {
            strBldr = new StringBuilder();
            strBldr.append(y);
            strBldr.append(" ");
            int x2 = 0;
            while (x2 < numArrays) {
                double[] data = dataList.get(x2);
                if (data.length >= maxRows) {
                    strBldr.append(", ");
                    strBldr.append(data[y]);
                }
                ++x2;
            }
            strBldr.append("\n");
            try {
                this.fw.write(strBldr.toString());
            }
            catch (IOException e) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, e);
            }
            ++y;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException e) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, e);
        }
    }

    public void logData(int dimension, List<PhaseSpaceCoordinate[]> dataList) {
        int maxRows = 0;
        int numArrays = dataList.size();
        int i = 0;
        while (i < numArrays) {
            PhaseSpaceCoordinate[] data = dataList.get(i);
            if (data.length >= maxRows) {
                maxRows = data.length;
            }
            ++i;
        }
        int y = 0;
        while (y < maxRows) {
            StringBuilder strBldr = new StringBuilder();
            int x = 0;
            while (x < numArrays) {
                PhaseSpaceCoordinate[] data = dataList.get(x);
                if (data.length >= maxRows) {
                    strBldr.append(data[y].xValue);
                    strBldr.append(", ");
                    strBldr.append(data[y].yValue);
                    strBldr.append("  ");
                    if (x < numArrays - 1) {
                        strBldr.append(", ");
                    }
                }
                ++x;
            }
            strBldr.append("\n");
            try {
                this.fw.write(strBldr.toString());
            }
            catch (IOException e) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, e);
            }
            ++y;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException e) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, e);
        }
    }

    public void logData(Map<Map<String, String>, ErrorResult> data) {
        try {
            Map<String, String> firstResult = data.keySet().iterator().next();
            Set<String> parms = firstResult.keySet();
            for (String string : parms) {
                this.fw.write(string);
                this.fw.write(",");
            }
            this.fw.write("RMS");
            this.fw.write("\n");
            for (Map map : data.keySet()) {
                ErrorResult res = data.get(map);
                Collection pvalues = map.values();
                for (String pval : pvalues) {
                    this.fw.write(pval);
                    this.fw.write(",");
                }
                double error = 0.0;
                if (res != null) {
                    error = res.getError();
                }
                this.fw.write(String.valueOf(error));
                this.fw.write("\n");
            }
        }
        catch (IOException ioe) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, ioe);
        }
    }

    public void flushLoggerData() {
        try {
            if (this.fw != null) {
                this.fw.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public void closeLoggerData() {
        this.flushLoggerData();
        if (this.fw == null) {
            return;
        }
        try {
            this.fw.close();
        }
        catch (IOException e) {
            Activator.logError("Error CLOSING CSV Logger file" + this.outputFileName + this.outputFileName, e);
        }
    }
}

