/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class AggregateCSVFile {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: AggregateCSVFile <csv file> <output file>\nOutput file is optional and if not specified the name will be generated from the input file.");
            System.exit(-1);
        }
        String cvsfilename = args[0];
        String outfilename = null;
        outfilename = args.length == 1 ? String.valueOf(args[0]) + "_aggregate.csv" : args[1];
        HashMap<Integer, Double> aggregate = new HashMap<Integer, Double>();
        ArrayList<Integer> iteration = new ArrayList<Integer>();
        ArrayList<String> time = new ArrayList<String>();
        try {
            int it;
            FileInputStream fis = new FileInputStream(cvsfilename);
            BufferedReader d = new BufferedReader(new InputStreamReader(fis));
            String header = null;
            header = d.readLine();
            if (header == null) {
                System.err.println("Error, file is empty!");
                System.exit(-2);
            }
            String data = null;
            while ((data = d.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(data, ",");
                int column = 0;
                it = 0;
                while (st.hasMoreTokens()) {
                    String val = st.nextToken().trim();
                    if (column == 0) {
                        it = Integer.parseInt(val);
                        iteration.add(it);
                    } else if (column == 1) {
                        time.add(val);
                    } else if (aggregate.containsKey(it)) {
                        aggregate.put(it, (Double)aggregate.get(it) + Double.parseDouble(val));
                    } else {
                        aggregate.put(it, Double.parseDouble(val));
                    }
                    ++column;
                }
            }
            d.close();
            FileWriter fw = new FileWriter(outfilename);
            fw.write("iteration,time,aggregate\n");
            int row = 0;
            Iterator iterator = iteration.iterator();
            while (iterator.hasNext()) {
                it = (Integer)iterator.next();
                fw.write(String.valueOf(it) + ",");
                fw.write(String.valueOf((String)time.get(row)) + ",");
                fw.write(aggregate.get(it) + "\n");
                ++row;
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

