/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class WatchpointFieldChange
extends WatchpointChange {
    private IField fDestField;

    public WatchpointFieldChange(IJavaWatchpoint watchpoint, IField destField) throws CoreException {
        super(watchpoint);
        this.fDestField = destField;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.WatchpointFieldChange_0, (Object[])new String[]{this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()), this.fDestField.getElementName()});
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)this.fDestField);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)this.fDestField);
        int[] range = this.getNewLineNumberAndRange((IMember)this.fDestField);
        IJavaWatchpoint breakpoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)this.fDestField.getDeclaringType().getFullyQualifiedName(), (String)this.fDestField.getElementName(), (int)-1, (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

