/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Map;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.eclipse.birt.core.script.BaseScriptable;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ScriptableParameter
extends BaseScriptable
implements Wrapper {
    private Map parameters;
    private String parameterName;
    private static final String JS_CLASS_NAME = "ScriptableParameters";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_DISPLAY_TEXT = "displayText";

    public ScriptableParameter(Map parameters, String parameterName, Scriptable parent) {
        this.setParentScope(parent);
        this.parameters = parameters;
        this.parameterName = parameterName;
    }

    public Object get(String name, Scriptable scope) {
        ParameterAttribute parameter = this.getParameterAttribute(name);
        if (FIELD_VALUE.equals(name)) {
            return parameter.getValue();
        }
        if (FIELD_DISPLAY_TEXT.equals(name)) {
            return parameter.getDisplayText();
        }
        Object value = parameter.getValue();
        Scriptable jsValue = Context.toObject((Object)value, (Scriptable)scope);
        Scriptable prototype = jsValue.getPrototype();
        if (prototype != null) {
            Object property = jsValue.getPrototype().get(name, jsValue);
            if (property instanceof Callable) {
                Callable callable = (Callable)property;
                return new JsValueCallable(callable, jsValue);
            }
            return jsValue.get(name, jsValue);
        }
        return jsValue.get(name, jsValue);
    }

    private ParameterAttribute getParameterAttribute(String name) {
        Object value = this.parameters.get(this.parameterName);
        if (value == null) {
            String errorMessage = CoreMessages.getFormattedString("birt.core.Javascript.parameterNotExist", name);
            throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
        }
        assert (value instanceof ParameterAttribute);
        ParameterAttribute parameter = (ParameterAttribute)value;
        return parameter;
    }

    public Object getDefaultValue(Class hint) {
        Object value = this.parameters.get(this.parameterName);
        if (value == null) {
            return null;
        }
        assert (value instanceof ParameterAttribute);
        ParameterAttribute parameter = (ParameterAttribute)value;
        return parameter.getValue();
    }

    public boolean has(String name, Scriptable scope) {
        if (FIELD_VALUE.equals(name) || FIELD_DISPLAY_TEXT.equals(name)) {
            return true;
        }
        ParameterAttribute parameter = this.getParameterAttribute(name);
        Scriptable jsValue = Context.toObject((Object)parameter.getValue(), (Scriptable)scope);
        if (jsValue != null) {
            return jsValue.has(name, scope);
        }
        return false;
    }

    public void put(String name, Scriptable scope, Object value) {
        Object parameterValue = this.parameters.get(this.parameterName);
        if (parameterValue == null) {
            return;
        }
        assert (parameterValue instanceof ParameterAttribute);
        ParameterAttribute parameter = (ParameterAttribute)parameterValue;
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (FIELD_VALUE.equals(name)) {
            parameter.setValue(value);
        } else if (FIELD_DISPLAY_TEXT.equals(name)) {
            parameter.setDisplayText((String)value);
        }
    }

    public String getClassName() {
        return JS_CLASS_NAME;
    }

    public Object unwrap() {
        Object value = this.parameters.get(this.parameterName);
        if (value != null) {
            return ((ParameterAttribute)value).getValue();
        }
        return null;
    }

    public static class JsValueCallable
    implements Callable {
        private Callable impl;
        private Scriptable value;

        public JsValueCallable(Callable callable, Scriptable value) {
            this.impl = callable;
            this.value = value;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            return this.impl.call(cx, scope, this.value, args);
        }
    }
}

