/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.preferences.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SolverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int DEFAULT_SIMULATION_THREADS = 2;
    public static final String DEFAULT_SOLVER = "org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl";

    public SolverPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("DMPPageTITLE"));
    }

    public void createFieldEditors() {
        IntegerFieldEditor simulationThreadsFieldEditor = new IntegerFieldEditor("simulationThreads", Messages.getString("DMPPageSimThreads"), this.getFieldEditorParent());
        this.addField((FieldEditor)simulationThreadsFieldEditor);
        Solver[] solvers = SolverPreferencePage.getSolvers();
        String[][] namesAndValues = new String[solvers.length][2];
        int i = 0;
        while (i < solvers.length) {
            namesAndValues[i][0] = solvers[i].getClass().getSimpleName();
            namesAndValues[i][1] = solvers[i].getClass().getName();
            ++i;
        }
        ComboFieldEditor comboFieldEditor = new ComboFieldEditor("defaultSolver", Messages.getString("DMPPageDefaultSolver"), namesAndValues, this.getFieldEditorParent());
        this.addField((FieldEditor)comboFieldEditor);
    }

    public static Solver[] getSolvers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] solverConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
        ArrayList<Solver> temp = new ArrayList<Solver>();
        int i = 0;
        while (i < solverConfigElements.length) {
            IConfigurationElement element = solverConfigElements[i];
            if (element.getName().equals("classdef")) {
                try {
                    temp.add((Solver)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    Activator.logError("Can't create solver", e);
                }
            }
            ++i;
        }
        Solver[] solvers = temp.toArray(new Solver[0]);
        return solvers;
    }

    public void init(IWorkbench workbench) {
    }
}

