/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameter;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkingCandidate<LinkingCandidate extends ILinkingCandidate<LinkingCandidate>>
implements ILinkingCandidate<LinkingCandidate> {
    private final IEObjectDescription description;
    private final AbstractTypeComputationState state;
    private final XExpression expression;

    protected AbstractLinkingCandidate(XExpression expression, IEObjectDescription description, AbstractTypeComputationState state) {
        this.expression = expression;
        this.description = description;
        this.state = state;
    }

    @Override
    public List<JvmFormalParameter> getDeclaredParameters() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmExecutable) {
            return ((JvmExecutable)feature).getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public void apply() {
        JvmIdentifiableElement feature = this.getFeature();
        JvmTypeReference featureType = this.getDeclaredType(feature);
        this.state.getResolvedTypes().acceptLinkingInformation(this.getExpression(), this);
        this.computeArgumentTypes(feature, featureType);
        List<ITypeExpectation> expectations = this.state.getImmediateExpectations();
        for (ITypeExpectation expectation : expectations) {
            this.acceptActualType(expectation, featureType);
        }
    }

    protected void acceptActualType(ITypeExpectation expectation, JvmTypeReference featureType) {
        this.deferredBindTypeArguments(expectation, featureType);
        expectation.acceptActualType(featureType, ConformanceHint.UNCHECKED);
    }

    protected JvmTypeReference asWrapperType(JvmTypeReference potentialPrimitive) {
        if (potentialPrimitive instanceof XComputedTypeReference && ((XComputedTypeReference)potentialPrimitive).getTypeProvider() instanceof UnboundTypeParameter) {
            return potentialPrimitive;
        }
        Primitives primitives = this.state.getServices().getPrimitives();
        JvmTypeReference result = primitives.asWrapperTypeIfPrimitive(potentialPrimitive);
        return result;
    }

    protected JvmTypeParameter getTypeParameter(JvmTypeReference referenceToTypeParameter) {
        if (referenceToTypeParameter instanceof XComputedTypeReference) {
            if (((XComputedTypeReference)referenceToTypeParameter).getTypeProvider() instanceof UnboundTypeParameter) {
                return null;
            }
            return this.getTypeParameter(((XComputedTypeReference)referenceToTypeParameter).getEquivalent());
        }
        JvmType result = referenceToTypeParameter.getType();
        if (result instanceof JvmTypeParameter) {
            return (JvmTypeParameter)result;
        }
        return null;
    }

    protected void deferredBindTypeArguments(ITypeExpectation expectation, JvmTypeReference type) {
        JvmTypeReference expectedType = expectation.getExpectedType();
        if (expectedType != null) {
            new AbstractTypeReferencePairWalker(this.getState().getServices()){

                @Override
                protected TypeParameterSubstitutor createTypeParameterSubstitutor(Map<JvmTypeParameter, JvmTypeReference> mapping) {
                    return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getServices());
                }

                @Override
                protected AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser createWildcardTypeReferenceTraverser() {
                    return new AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser(this){

                        public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmWildcardTypeReference declaration) {
                            if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                                return super.doVisitTypeReference((JvmTypeReference)reference, declaration);
                            }
                            return (Void)super.doVisitComputedTypeReference(reference, declaration);
                        }
                    };
                }

                @Override
                public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmTypeReference param) {
                    if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                        UnboundTypeParameter typeParameter = (UnboundTypeParameter)reference.getTypeProvider();
                        JvmTypeReference wrapped = AbstractLinkingCandidate.this.asWrapperType(param);
                        typeParameter.acceptHint(wrapped);
                        return null;
                    }
                    return (Void)super.doVisitComputedTypeReference(reference, param);
                }

                @Override
                protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
                    return new AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser(this){

                        public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmParameterizedTypeReference declaration) {
                            if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                                UnboundTypeParameter typeParameter = (UnboundTypeParameter)reference.getTypeProvider();
                                JvmTypeReference wrapped = AbstractLinkingCandidate.this.asWrapperType((JvmTypeReference)declaration);
                                typeParameter.acceptHint(wrapped);
                                return null;
                            }
                            return (Void)super.doVisitComputedTypeReference(reference, declaration);
                        }

                        protected boolean allowToVisitTwice() {
                            return false;
                        }
                    };
                }

                @Override
                protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, JvmTypeReference> mapping, Collection<JvmTypeParameter> visited) {
                    for (Map.Entry<JvmTypeParameter, JvmTypeReference> entry : mapping.entrySet()) {
                        JvmTypeReference reference = entry.getValue();
                        JvmType type = null;
                        if (reference instanceof XComputedTypeReference) {
                            IJvmTypeReferenceProvider typeProvider = ((XComputedTypeReference)reference).getTypeProvider();
                            if (typeProvider instanceof UnboundTypeParameter) {
                                type = ((UnboundTypeParameter)typeProvider).getTypeParameter();
                            }
                        } else {
                            type = reference.getType();
                        }
                        if (parameter != type) continue;
                        if (visited.add(entry.getKey())) {
                            return entry.getKey();
                        }
                        return null;
                    }
                    return null;
                }
            }.processPairedReferences(expectedType, type);
        }
    }

    protected JvmTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        return this.state.getType(feature);
    }

    protected Map<JvmTypeParameter, JvmTypeReference> getDeclaratorParameterMapping() {
        return Collections.emptyMap();
    }

    protected void computeArgumentTypes(JvmIdentifiableElement feature, JvmTypeReference featureType) {
        int i;
        int declaredParameterCount = 0;
        int fixedArityParameterCount = 0;
        EList parameters = null;
        boolean varArgs = false;
        if (feature instanceof JvmExecutable) {
            JvmExecutable executable = (JvmExecutable)feature;
            declaredParameterCount = executable.getParameters().size();
            varArgs = executable.isVarArgs();
            fixedArityParameterCount = varArgs ? declaredParameterCount - 1 : declaredParameterCount;
            parameters = executable.getParameters();
        }
        List<XExpression> arguments = this.getArguments();
        int fixedArityArgumentCount = Math.min(fixedArityParameterCount, arguments.size());
        ArrayList stackedResolvedTypes = Lists.newArrayListWithCapacity((int)arguments.size());
        if (parameters != null) {
            i = 0;
            while (i < fixedArityArgumentCount) {
                JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(i);
                JvmTypeReference parameterType = parameter.getParameterType();
                XExpression argument = arguments.get(i);
                AbstractTypeComputationState argumentState = this.state.fork().withExpectation(parameterType);
                stackedResolvedTypes.add(this.resolveArgumentType(argument, parameterType, argumentState));
                ++i;
            }
            if (varArgs) {
                int lastParamIndex = declaredParameterCount - 1;
                JvmTypeReference lastParameterType = ((JvmFormalParameter)parameters.get(lastParamIndex)).getParameterType();
                if (!(lastParameterType instanceof JvmGenericArrayTypeReference)) {
                    throw new IllegalStateException("Unexpected var arg type: " + lastParameterType);
                }
                JvmTypeReference componentType = ((JvmGenericArrayTypeReference)lastParameterType).getComponentType();
                AbstractTypeComputationState argumentState = null;
                argumentState = arguments.size() == declaredParameterCount ? this.state.fork().withExpectation(componentType) : this.state.fork().withExpectation(componentType);
                int i2 = fixedArityArgumentCount;
                while (i2 < arguments.size()) {
                    XExpression argument = arguments.get(i2);
                    stackedResolvedTypes.add(this.resolveArgumentType(argument, null, argumentState));
                    ++i2;
                }
            }
        }
        if (!varArgs) {
            i = fixedArityArgumentCount;
            while (i < arguments.size()) {
                XExpression argument = arguments.get(i);
                stackedResolvedTypes.add(this.resolveArgumentType(argument, null, this.state.fork().withNonVoidExpectation()));
                ++i;
            }
        }
        for (StackedResolvedTypes pending : stackedResolvedTypes) {
            pending.mergeIntoParent();
        }
    }

    protected StackedResolvedTypes resolveArgumentType(XExpression argument, JvmTypeReference declaredType, AbstractTypeComputationState argumentState) {
        return argumentState.computeTypesWithoutMerge(argument);
    }

    @Override
    public List<XExpression> getArguments() {
        XExpression receiver;
        List<XExpression> arguments = this.getSyntacticArguments();
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmOperation && ((JvmOperation)feature).isStatic() && (receiver = this.getReceiver()) != null) {
            ArrayList result = Lists.newArrayListWithCapacity((int)(1 + arguments.size()));
            result.add(receiver);
            result.addAll(arguments);
            return result;
        }
        return arguments;
    }

    @Override
    public int compareTo(LinkingCandidate right) {
        int arityCompareResult = this.compareByArityWith(right);
        if (arityCompareResult != 0) {
            return arityCompareResult;
        }
        int typeArityCompareResult = this.compareByArity(this.getTypeArityMismatch(), right.getTypeArityMismatch());
        if (typeArityCompareResult != 0) {
            return typeArityCompareResult;
        }
        if (this.getDeclaredTypeParameters().size() > right.getDeclaredTypeParameters().size()) {
            return 1;
        }
        return 0;
    }

    protected int compareByArityWith(LinkingCandidate right) {
        int arityCompareResult = this.compareByArity(this.getArityMismatch(), right.getArityMismatch());
        return arityCompareResult;
    }

    protected int compareByArity(int leftArityMismatch, int rightArityMismatch) {
        if (leftArityMismatch != rightArityMismatch) {
            if (leftArityMismatch == 0) {
                return -1;
            }
            if (rightArityMismatch == 0) {
                return 1;
            }
            if (Math.abs(leftArityMismatch) < Math.abs(rightArityMismatch)) {
                return -1;
            }
            if (Math.abs(leftArityMismatch) > Math.abs(rightArityMismatch)) {
                return 1;
            }
            if (leftArityMismatch > 0) {
                return -1;
            }
            if (rightArityMismatch > 0) {
                return 1;
            }
        }
        if (Math.abs(leftArityMismatch) < Math.abs(rightArityMismatch)) {
            return -1;
        }
        if (Math.abs(leftArityMismatch) > Math.abs(rightArityMismatch)) {
            return 1;
        }
        if (leftArityMismatch > 0) {
            return -1;
        }
        if (rightArityMismatch > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getArityMismatch() {
        JvmIdentifiableElement identifiable = this.getFeature();
        if (identifiable instanceof JvmExecutable) {
            return this.getArityMismatch((JvmExecutable)identifiable, this.getArguments());
        }
        return this.getArguments().size();
    }

    @Override
    public int getTypeArityMismatch() {
        List<JvmTypeReference> explicitTypeArguments = this.getTypeArguments();
        if (explicitTypeArguments.size() == 0) {
            return 0;
        }
        return this.getDeclaredTypeParameters().size() - explicitTypeArguments.size();
    }

    protected abstract List<JvmTypeReference> getTypeArguments();

    protected int getArityMismatch(JvmExecutable executable, List<XExpression> arguments) {
        int fixedArityParamCount = executable.getParameters().size();
        if (executable.isVarArgs() && arguments.size() >= --fixedArityParamCount) {
            return 0;
        }
        return fixedArityParamCount - arguments.size();
    }

    protected abstract List<XExpression> getSyntacticArguments();

    protected IEObjectDescription getDescription() {
        return this.description;
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return (JvmIdentifiableElement)this.getDescription().getEObjectOrProxy();
    }

    protected XExpression getReceiver() {
        if (this.getDescription() instanceof BucketedEObjectDescription) {
            return ((BucketedEObjectDescription)this.getDescription()).getReceiver();
        }
        return null;
    }

    protected XExpression getExpression() {
        return this.expression;
    }

    protected AbstractTypeComputationState getState() {
        return this.state;
    }
}

