/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentAction;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewComparator;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewPageContentProvider;
import org.eclipse.pde.internal.ui.views.plugins.ImportActionGroup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.Page;

public abstract class DependenciesViewPage
extends Page {
    private Action fFocusOnAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private Action fOpenAction;
    protected PDERefactoringAction fRefactorAction;
    private IPropertyChangeListener fPropertyListener;
    private DependenciesView fView;
    protected StructuredViewer fViewer;
    protected IContentProvider fContentProvider;
    private Action fHideFragmentFilterAction;
    protected Action fHideOptionalFilterAction;
    private FragmentFilter fHideFragmentFilter = new FragmentFilter();
    private static final String HIDE_FRAGMENTS = "hideFrags";
    private static final String HIDE_OPTIONAL = "hideOptional";

    public DependenciesViewPage(DependenciesView view, IContentProvider contentProvider) {
        this.fView = view;
        this.fContentProvider = contentProvider;
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("Preferences.MainPage.showObjects")) {
                    DependenciesViewPage.this.fViewer.refresh();
                }
            }
        };
    }

    public void createControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.fViewer.setComparator((ViewerComparator)DependenciesViewComparator.getViewerComparator());
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    public void dispose() {
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        super.dispose();
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() == 1) {
            manager.add((IAction)this.fOpenAction);
            manager.add((IContributionItem)new Separator());
        }
        if (ImportActionGroup.canImport(selection)) {
            ImportActionGroup actionGroup = new ImportActionGroup();
            actionGroup.setContext(new ActionContext((ISelection)selection));
            actionGroup.fillContextMenu(manager);
            manager.add((IContributionItem)new Separator());
        }
        this.fFocusOnSelectionAction.update(this.getSelectedObject());
        if (this.fFocusOnSelectionAction.isEnabled()) {
            manager.add((IAction)this.fFocusOnSelectionAction);
        }
        manager.add((IAction)this.fFocusOnAction);
        Object selectionElement = selection.getFirstElement();
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1 && !this.fView.isShowingCallers()) {
            String id = null;
            if (selectionElement instanceof BundleSpecification) {
                id = ((BundleSpecification)selectionElement).getName();
            } else if (selectionElement instanceof BundleDescription) {
                id = ((BundleDescription)selectionElement).getSymbolicName();
            }
            if (id != null && PluginRegistry.findModel((String)id) != null) {
                Object input = this.fViewer.getInput();
                if (input instanceof IPluginBase) {
                    input = ((IPluginBase)input).getModel();
                }
                if (input instanceof IPluginModelBase) {
                    IResource res;
                    IPluginModelBase base = (IPluginModelBase)input;
                    IResource iResource = res = base == null ? null : base.getUnderlyingResource();
                    if (res != null) {
                        manager.add((IAction)new DependencyExtentAction(res.getProject(), id));
                    }
                }
            }
        }
        IPluginModelBase model = null;
        if (selectionElement instanceof BundleSpecification) {
            model = PluginRegistry.findModel((String)((BundleSpecification)selectionElement).getName());
        } else if (selectionElement instanceof BundleDescription) {
            model = PluginRegistry.findModel((BundleDescription)((BundleDescription)selectionElement));
        } else if (selectionElement instanceof IPluginBase) {
            model = ((IPluginBase)selectionElement).getModel();
        }
        if (model != null && model.getUnderlyingResource() != null) {
            manager.add((IAction)new UnusedDependenciesAction(model, true));
        }
        if (this.enableRename(selection)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fRefactorAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fViewer.getSelection();
    }

    protected void setSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            this.fViewer.setSelection((ISelection)selection, true);
        }
    }

    public DependenciesView getView() {
        return this.fView;
    }

    private void handleDoubleClick() {
        Object obj = this.getSelectedObject();
        BundleDescription desc = null;
        if (obj instanceof BundleSpecification) {
            desc = (BundleDescription)((BundleSpecification)obj).getSupplier();
        } else if (obj instanceof BundleDescription) {
            desc = (BundleDescription)obj;
        } else if (obj instanceof IPluginBase) {
            desc = ((IPluginModelBase)((IPluginBase)obj).getModel()).getBundleDescription();
        } else if (obj instanceof ImportPackageSpecification) {
            BaseDescription export = ((ImportPackageSpecification)obj).getSupplier();
            desc = ((ExportPackageDescription)export).getExporter();
        }
        if (desc != null) {
            ManifestEditor.openPluginEditor(desc);
        }
    }

    private void handleFocusOn() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.fViewer.getControl().getShell(), true, false);
        dialog.create();
        if (dialog.open() == 0) {
            this.handleFocusOn(dialog.getFirstResult());
        }
    }

    private void handleFocusOn(Object newFocus) {
        if (newFocus instanceof IPluginModelBase) {
            this.fView.openTo(newFocus);
        }
        if (newFocus instanceof IPluginBase) {
            this.fView.openTo(((IPluginBase)newFocus).getModel());
        }
        if (newFocus instanceof IPluginImport) {
            IPluginImport pluginImport = (IPluginImport)newFocus;
            String id = pluginImport.getId();
            IPluginModelBase model = PluginRegistry.findModel((String)id);
            if (model != null) {
                this.fView.openTo(model);
            } else {
                this.fView.openTo(null);
            }
        }
        BundleDescription desc = null;
        if (newFocus instanceof BundleSpecification && (desc = (BundleDescription)((BundleSpecification)newFocus).getSupplier()) == null) {
            this.fView.openTo(null);
        }
        if (newFocus instanceof BundleDescription) {
            desc = (BundleDescription)newFocus;
        }
        if (desc != null) {
            this.fView.openTo(PluginRegistry.findModel((String)desc.getSymbolicName()));
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DependenciesViewPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fView.getSite().getId(), menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DependenciesViewPage.this.handleDoubleClick();
            }
        });
    }

    private void makeActions() {
        this.fOpenAction = new Action(){

            public void run() {
                DependenciesViewPage.this.handleDoubleClick();
            }
        };
        this.fOpenAction.setText(PDEUIMessages.DependenciesView_open);
        this.fFocusOnSelectionAction = new FocusOnSelectionAction();
        this.fFocusOnAction = new Action(){

            public void run() {
                DependenciesViewPage.this.handleFocusOn();
            }
        };
        this.fFocusOnAction.setText(PDEUIMessages.DependenciesViewPage_focusOn);
        this.fFocusOnAction.setImageDescriptor(PDEPluginImages.DESC_FOCUS_ON);
        this.fRefactorAction = RefactoringActionFactory.createRefactorPluginIdAction();
        this.fHideFragmentFilterAction = new Action(){

            public void run() {
                boolean checked = DependenciesViewPage.this.fHideFragmentFilterAction.isChecked();
                if (checked) {
                    DependenciesViewPage.this.fViewer.removeFilter((ViewerFilter)DependenciesViewPage.this.fHideFragmentFilter);
                } else {
                    DependenciesViewPage.this.fViewer.addFilter((ViewerFilter)DependenciesViewPage.this.fHideFragmentFilter);
                }
                DependenciesViewPage.this.getSettings().put(DependenciesViewPage.HIDE_FRAGMENTS, !checked);
            }
        };
        this.fHideFragmentFilterAction.setText(PDEUIMessages.DependenciesViewPage_showFragments);
        this.fHideOptionalFilterAction = new Action(){

            public void run() {
                boolean checked = this.isChecked();
                DependenciesViewPage.this.handleShowOptional(this.isChecked(), true);
                DependenciesViewPage.this.getSettings().put(DependenciesViewPage.HIDE_OPTIONAL, !checked);
            }
        };
        this.fHideOptionalFilterAction.setText(PDEUIMessages.DependenciesViewPage_showOptional);
    }

    protected abstract void handleShowOptional(boolean var1, boolean var2);

    protected abstract boolean isShowingOptional();

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars(this.getSite().getActionBars());
    }

    public void setFocus() {
        Control c;
        if (this.fViewer != null && !(c = this.fViewer.getControl()).isFocusControl()) {
            c.setFocus();
        }
    }

    public void setInput(Object object) {
        if (object != this.fViewer.getInput()) {
            this.fViewer.setInput(object);
        }
    }

    protected boolean enableRename(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object selectionElement = selection.getFirstElement();
            IPluginModelBase base = null;
            if (selectionElement instanceof IPluginImport) {
                String id = ((IPluginImport)selectionElement).getId();
                base = PluginRegistry.findModel((String)id);
            } else if (selectionElement instanceof IPluginObject) {
                base = (IPluginModelBase)((IPluginObject)selectionElement).getModel();
            } else if (selectionElement instanceof BundleSpecification) {
                BundleDescription desc = (BundleDescription)((BundleSpecification)selectionElement).getSupplier();
                if (desc != null) {
                    base = PluginRegistry.findModel((BundleDescription)desc);
                }
            } else if (selectionElement instanceof BundleDescription) {
                base = PluginRegistry.findModel((BundleDescription)((BundleDescription)selectionElement));
            }
            if (base != null && base.getUnderlyingResource() != null) {
                this.fRefactorAction.setSelection(base);
                return true;
            }
        }
        return false;
    }

    public void setActive(boolean active) {
        if (active) {
            if (this.fView.isShowingCallers()) {
                this.fHideOptionalFilterAction.setChecked(true);
                this.fHideOptionalFilterAction.setEnabled(false);
            } else {
                this.fHideOptionalFilterAction.setEnabled(true);
                this.fHideOptionalFilterAction.setChecked(!this.getSettings().getBoolean(HIDE_OPTIONAL));
            }
            this.fHideFragmentFilterAction.setChecked(!this.getSettings().getBoolean(HIDE_FRAGMENTS));
            boolean showFragments = this.fHideFragmentFilterAction.isChecked();
            boolean containsFragments = true;
            ViewerFilter[] filters = this.fViewer.getFilters();
            int i = 0;
            while (i < filters.length) {
                if (filters[i].equals((Object)this.fHideFragmentFilter)) {
                    containsFragments = false;
                    break;
                }
                ++i;
            }
            if (showFragments != containsFragments) {
                if (showFragments) {
                    this.fViewer.removeFilter((ViewerFilter)this.fHideFragmentFilter);
                } else {
                    this.fViewer.addFilter((ViewerFilter)this.fHideFragmentFilter);
                }
            }
            if (this.fHideOptionalFilterAction.isChecked() != this.isShowingOptional()) {
                this.handleShowOptional(this.fHideOptionalFilterAction.isChecked(), false);
            }
        }
        if (this.fContentProvider instanceof DependenciesViewPageContentProvider) {
            if (active) {
                ((DependenciesViewPageContentProvider)this.fContentProvider).attachModelListener();
                this.fViewer.refresh();
            } else {
                ((DependenciesViewPageContentProvider)this.fContentProvider).removeModelListener();
            }
        }
    }

    private void contributeToActionBars(IActionBars actionBars) {
        IToolBarManager manager = actionBars.getToolBarManager();
        manager.add((IAction)this.fFocusOnAction);
        this.contributeToDropDownMenu(actionBars.getMenuManager());
    }

    private void contributeToDropDownMenu(IMenuManager manager) {
        manager.add((IAction)this.fHideFragmentFilterAction);
        manager.add((IAction)this.fHideOptionalFilterAction);
        IDialogSettings settings = this.getSettings();
        boolean hideFragments = settings.getBoolean(HIDE_FRAGMENTS);
        boolean hideOptional = settings.getBoolean(HIDE_OPTIONAL);
        this.fHideFragmentFilterAction.setChecked(!hideFragments);
        this.fHideOptionalFilterAction.setChecked(!hideOptional);
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection("dependenciesView");
        if (section == null) {
            section = master.addNewSection("dependenciesView");
        }
        return section;
    }

    class FocusOnSelectionAction
    extends Action {
        FocusOnSelectionAction() {
        }

        public void run() {
            DependenciesViewPage.this.handleFocusOn(DependenciesViewPage.this.getSelectedObject());
        }

        public void update(Object object) {
            this.setEnabled(object != null);
            String name = ((LabelProvider)DependenciesViewPage.this.fViewer.getLabelProvider()).getText(object);
            this.setText(NLS.bind((String)PDEUIMessages.DependenciesViewPage_focusOnSelection, (Object)name));
            this.setImageDescriptor(PDEPluginImages.DESC_FOCUS_ON);
        }
    }

    class FragmentFilter
    extends ViewerFilter {
        FragmentFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            BundleDescription desc = null;
            if (element instanceof BundleSpecification) {
                BaseDescription supplier = ((BundleSpecification)element).getSupplier();
                if (supplier instanceof BundleDescription) {
                    desc = (BundleDescription)supplier;
                }
            } else if (element instanceof BundleDescription) {
                desc = (BundleDescription)element;
            } else if (element instanceof ImportPackageSpecification) {
                BaseDescription export = ((ImportPackageSpecification)element).getSupplier();
                desc = ((ExportPackageDescription)export).getExporter();
            }
            if (desc != null) {
                return desc.getHost() == null;
            }
            return true;
        }
    }
}

