/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEViewActions;
import org.eclipse.stem.ui.ge.views.GEViewContentProvider;
import org.eclipse.stem.ui.ge.views.GEViewLabelProvider;
import org.eclipse.stem.ui.ge.views.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class GEView
extends ViewPart {
    public static final String ID_GE_VIEW = "org.eclipse.stem.ui.views.ge";
    private ListViewer viewer = null;
    private Activator uiActivator = null;
    private static ColorRegistry colorRegistry = null;
    private GEViewContentProvider contentProvider = null;
    private GEInterface gei = null;
    private static boolean active = false;
    private static final int STANDARD_LENGTH = 370;
    private static final int STANDARD_HEIGHT = 15;

    public GEView() {
        if (active) {
            GELog.error("STEM - GoogleEarth interface already active", null);
            throw new RuntimeException("Duplicate");
        }
        active = true;
        this.gei = new GEInterface(this);
        GELog.debug(GEView.class, "gei=" + this.gei);
        if (colorRegistry == null) {
            this.uiActivator = Activator.getDefault();
            colorRegistry = this.uiActivator.getColorRegistry();
        }
    }

    public void createPartControl(Composite parent) {
        boolean autoLaunch;
        GEViewActions actions;
        boolean debug = GEPreferencePage.isDebug();
        if (debug) {
            GELog.DEBUG = true;
            GELog.debug((Object)this, "Debug option turned on.");
        } else {
            GELog.debug((Object)this, "Debug option being turned off.");
            GELog.DEBUG = false;
        }
        GELog.debug("GEView.createPartControl:");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        String aspect = Aspect.getDefaultCode();
        this.createControlButtons(parent, aspect);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Composite control = this.getScrollable(parent, gridData);
        control.setLayout((Layout)new FillLayout());
        this.viewer = new ListViewer(control);
        this.contentProvider = new GEViewContentProvider(this.gei);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        GEViewLabelProvider lp = new GEViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)lp);
        lp.setGEI(this.gei);
        this.viewer.setInput((Object)SimulationManager.getManager());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IWorkbenchWindow ww = this.getSite().getWorkbenchWindow();
        ISelectionService ss = ww.getSelectionService();
        ss.addSelectionListener((ISelectionListener)this.contentProvider);
        boolean ok = this.gei.init();
        if (!ok) {
            GELog.debug((Object)this, this.gei.getErrorMessage());
            this.showMessage(this.gei.getErrorMessage());
            this.gei.setErrorMessage(null);
        }
        if ((actions = new GEViewActions(this, this.gei)) == null) {
            GELog.error("Unable to setup context menu", null);
        }
        if (autoLaunch = GEPreferencePage.isAutoLaunch()) {
            StemKml.launchGE();
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("GEView.27"), (String)message);
    }

    public String verifyFolder(String folder) {
        folder = this.folderDialog(folder);
        GELog.debug((Object)this, "verifyFolder=" + folder);
        if (folder != null) {
            GEPreferencePage.setFolder(folder);
        }
        return folder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String folderDialog(String deflt) {
        DirectoryDialog fd;
        String folder;
        block9: {
            folder = null;
            try {
                if (deflt != null) {
                    File defaultf = new File(deflt);
                    folder = defaultf.exists() && defaultf.isDirectory() ? deflt : null;
                }
                while (true) {
                    if (folder == null) {
                        File tmpFile = File.createTempFile("XXX", "tmp");
                        folder = tmpFile.getParent();
                        Shell shell = this.viewer.getControl().getShell();
                        int style = 65536;
                        fd = new DirectoryDialog(shell, style);
                        fd.setFilterPath(folder);
                        fd.setText(Messages.getString("GEView.30"));
                        fd.setMessage(Messages.getString("GEView.31"));
                        break block9;
                    }
                    boolean ok = this.checkContents(folder);
                    if (ok) {
                        return folder;
                    }
                    folder = null;
                }
            }
            catch (Exception t) {
                GELog.error("Folder Dialog", t);
            }
            return folder;
        }
        while ((folder = fd.open()) != null) {
            boolean ok;
            File dir = new File(folder);
            if (dir.exists() && dir.isDirectory() && (ok = this.checkContents(folder))) {
                return folder;
            }
            if (dir.exists()) continue;
            dir.mkdirs();
        }
        return null;
    }

    public String displayFolderDialog(String folder) {
        String displayFolder;
        block5: {
            displayFolder = null;
            try {
                block4: {
                    if (folder != null) {
                        File defaultf = new File(folder);
                        displayFolder = defaultf.exists() && defaultf.isDirectory() ? folder : null;
                    }
                    do {
                        Shell shell = this.viewer.getControl().getShell();
                        int style = 65536;
                        DirectoryDialog fd = new DirectoryDialog(shell, style);
                        fd.setFilterPath(displayFolder);
                        fd.setText(Messages.getString("GEView.30"));
                        fd.setMessage(Messages.getString("GEView.34"));
                        displayFolder = fd.open();
                        if (displayFolder == null) break block4;
                    } while (!this.validFolder(displayFolder));
                    break block5;
                }
                displayFolder = null;
            }
            catch (Exception t) {
                GELog.error("GEView: displayFolderDialog", t);
                displayFolder = null;
            }
        }
        return displayFolder;
    }

    private boolean validFolder(String folder) {
        boolean ok = false;
        File dir = new File(folder);
        if (dir.exists() && dir.isDirectory()) {
            File[] contents = this.fileList(dir);
            if (contents.length > 0) {
                ok = true;
            } else {
                Shell shell = this.viewer.getControl().getShell();
                int style = 65732;
                MessageBox question = new MessageBox(shell, style);
                String template = Messages.getString("GEView.33");
                String output = String.format(template, dir.getAbsolutePath());
                question.setMessage(output);
                int ans = question.open();
                if (ans == 64) {
                    ok = true;
                }
            }
        }
        return ok;
    }

    private boolean checkContents(String folder) {
        boolean ok = false;
        File dir = new File(folder);
        File[] contents = this.fileList(dir);
        if (contents.length == 0) {
            ok = true;
        } else {
            Shell shell = this.viewer.getControl().getShell();
            int style = 65988;
            MessageBox question = new MessageBox(shell, style);
            String template = Messages.getString("GEView.32");
            String output = String.format(template, dir.getAbsolutePath());
            question.setMessage(output);
            int ans = question.open();
            if (ans == 64) {
                try {
                    File[] fileArray = contents;
                    int n = contents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        f.delete();
                        ++n2;
                    }
                    ok = true;
                }
                catch (Exception e) {
                    GELog.error("Unable to delete KML files", e);
                }
            } else if (ans == 128) {
                ok = true;
            }
        }
        return ok;
    }

    private File[] fileList(File folder) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().toLowerCase().startsWith("net")) {
                    return false;
                }
                return f.getName().toLowerCase().endsWith(".kml");
            }
        };
        try {
            File[] files = folder.listFiles(ff);
            if (files == null) {
                return new File[0];
            }
            return files;
        }
        catch (Exception e) {
            GELog.error(e.getMessage(), e);
            return null;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ListViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        GELog.debug((Object)this, "Dispose()");
        this.gei.dispose();
        active = false;
    }

    public GEViewContentProvider getContentProvider() {
        return this.contentProvider;
    }

    private Composite getScrollable(Composite parent, GridData gridData) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setLayoutData((Object)gridData);
        scrollComposite.setMinSize(3000, 10000);
        Composite control = new Composite((Composite)scrollComposite, 0);
        scrollComposite.setContent((Control)control);
        return control;
    }

    protected Composite createControlButtons(Composite parent, String current) {
        Button display = new Button(parent, 8);
        display.setText("Display");
        display.setToolTipText("Display current map");
        display.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        ISimulation sim = GEView.this.contentProvider.getCurrentSimulation();
                        if (sim != null) {
                            boolean ok = GEView.this.gei.displayMap(sim);
                            if (ok) break;
                            GEView.this.showMessage(Messages.getString("GEView.15"));
                            break;
                        }
                        GEView.this.showMessage("No active Simulation");
                    }
                }
            }
        });
        Group btnContainer = null;
        btnContainer = new Group(parent, 4);
        btnContainer.setText("Select Aspect to be displayed");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        btnContainer.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 31;
        gridData.minimumHeight = 31;
        gridData.widthHint = 370;
        gridData.minimumWidth = 370;
        btnContainer.setLayoutData((Object)gridData);
        Button b_s = new Button((Composite)btnContainer, 16);
        Button b_e = new Button((Composite)btnContainer, 16);
        Button b_i = new Button((Composite)btnContainer, 16);
        Button b_r = new Button((Composite)btnContainer, 16);
        b_s.setText("S");
        b_s.setSelection("S".equals(current));
        b_s.setBackground(parent.getDisplay().getSystemColor(9));
        b_s.setForeground(parent.getDisplay().getSystemColor(1));
        b_s.setToolTipText("Suceptiple");
        b_s.setLayoutData((Object)this.getButtonGridData());
        b_e.setText("E");
        b_e.setSelection("E".equals(current));
        b_e.setBackground(parent.getDisplay().getSystemColor(7));
        b_e.setToolTipText("Exposed");
        b_e.setLayoutData((Object)this.getButtonGridData());
        b_i.setText("I");
        b_i.setSelection("I".equals(current));
        b_i.setBackground(parent.getDisplay().getSystemColor(3));
        b_i.setToolTipText("Infectious");
        b_i.setLayoutData((Object)this.getButtonGridData());
        b_r.setText("R");
        b_r.setSelection("R".equals(current));
        b_r.setBackground(parent.getDisplay().getSystemColor(5));
        b_r.setToolTipText("Recovered");
        b_r.setLayoutData((Object)this.getButtonGridData());
        b_s.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        GEView.this.setAspect("S");
                    }
                }
            }
        });
        b_e.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        GEView.this.setAspect("E");
                    }
                }
            }
        });
        b_i.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        GEView.this.setAspect("I");
                    }
                }
            }
        });
        b_r.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        GEView.this.setAspect("R");
                    }
                }
            }
        });
        GridData btngridData = new GridData();
        btngridData.horizontalAlignment = 4;
        btngridData.grabExcessHorizontalSpace = true;
        btnContainer.setLayoutData((Object)btngridData);
        return btnContainer;
    }

    private void setAspect(String aspectCode) {
        GELog.debug((Object)this, aspectCode);
        Aspect aspect = Aspect.getAspect(aspectCode);
        ISimulation sim = this.contentProvider.getCurrentSimulation();
        this.gei.setAspectToDisplay(sim, aspect);
    }

    protected GridData getButtonGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        return gridData;
    }
}

