/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.IdentifiableItemProvider;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.ModelPackage;

public class ModelItemProvider
extends IdentifiableItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ModelPackage.Literals.MODEL__MODELS);
            this.childrenFeatures.add(ModelPackage.Literals.MODEL__GRAPHS);
            this.childrenFeatures.add(ModelPackage.Literals.MODEL__GRAPH_DECORATORS);
            this.childrenFeatures.add(ModelPackage.Literals.MODEL__NODE_DECORATORS);
            this.childrenFeatures.add(ModelPackage.Literals.MODEL__EDGE_DECORATORS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        Object temp = child;
        if (child instanceof IFile) {
            IFile iFile = (IFile)child;
            URI uri = URI.createFileURI((String)iFile.getLocation().toString());
            Identifiable identifable = Utility.getIdentifiableForceLoad(uri);
            temp = identifable;
        } else if (child instanceof String) {
            String uriString = (String)child;
            try {
                URI uri = URI.createURI((String)uriString);
                Identifiable identifable = Utility.getIdentifiableForceLoad(uri);
                temp = identifable;
            }
            catch (Exception exception) {}
        }
        if (temp instanceof Identifiable) {
            return super.getChildFeature(object, temp);
        }
        return super.getChildFeature(object, child);
    }

    protected EStructuralFeature getChildFeatureGen(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Model"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String getTextGen(Object object) {
        URI labelValue = ((Model)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Model_type") : String.valueOf(this.getString("_UI_Model_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Model.class)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.MODEL__MODELS, ModelFactory.eINSTANCE.createModel()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.MODEL__GRAPHS, GraphFactory.eINSTANCE.createGraph()));
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return super.createDragAndDropCommand(domain, owner, location, operations | 4, operation, collection);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        ArrayList<Identifiable> identifiableCollection = new ArrayList<Identifiable>();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifiable identifable;
            URI uri;
            Object value;
            Object temp = value = iterator.next();
            if (value instanceof IFile) {
                IFile iFile = (IFile)value;
                uri = URI.createFileURI((String)iFile.getLocation().toString());
                identifable = Utility.getIdentifiableForceLoad(uri);
                identifiableCollection.add(identifable);
                temp = identifable;
            } else if (value instanceof String) {
                String uriString = (String)value;
                try {
                    uri = URI.createURI((String)uriString);
                    identifable = Utility.getIdentifiableForceLoad(uri);
                    temp = identifable;
                }
                catch (Exception exception) {}
            }
            if (!(temp instanceof Identifiable)) continue;
            identifiableCollection.add((Identifiable)temp);
        }
        return super.createAddCommand(domain, owner, feature, identifiableCollection, index);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this){

            protected Command createCommand() {
                Command retValue = null;
                Command createChildCommand = super.createCommand();
                Resource parentResource = this.owner.eResource();
                if (parentResource != null && (this.child instanceof Model || this.child instanceof Graph)) {
                    EObject temp = (EObject)this.child;
                    if (temp.eResource() == null) {
                        AddCommand addCommand = new AddCommand(this.domain, parentResource.getContents(), (Object)temp);
                        CompoundCommand compoundCommand = new CompoundCommand(0, createChildCommand.getLabel(), createChildCommand.getDescription());
                        compoundCommand.append(createChildCommand);
                        compoundCommand.append((Command)addCommand);
                        retValue = compoundCommand;
                    }
                } else {
                    retValue = createChildCommand;
                }
                return retValue;
            }
        };
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }
}

