/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.ui.views.IContextMenuUpdatesListener;
import org.eclipse.stem.ui.views.graphmap.GraphMapPreferences;
import org.eclipse.stem.ui.views.graphmap.GraphMapRegistry;
import org.eclipse.stem.ui.views.graphmap.GraphMapViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class GraphMapView
extends ViewPart
implements IContextMenuUpdatesListener {
    public static final String ID_GRAPH_MAP_VIEW = "org.eclipse.stem.ui.views.graphmap";
    private GraphMapViewer geographicViewer;

    public void createPartControl(Composite parent) {
        this.geographicViewer = new GraphMapViewer(parent, this);
        IWorkbenchPage page = this.getViewSite().getPage();
        page.addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part == GraphMapView.this) {
                    GraphMapRegistry.getInstance().registerView(GraphMapView.this);
                    GraphMapView.this.geographicViewer.setInput(SimulationManager.getManager());
                    GraphMapView.this.getSite().setSelectionProvider((ISelectionProvider)GraphMapView.this.geographicViewer);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == GraphMapView.this && !PlatformUI.getWorkbench().isClosing()) {
                    GraphMapPreferences prefs = GraphMapPreferences.getInstance();
                    int viewId = GraphMapRegistry.getInstance().getViewId(GraphMapView.this);
                    prefs.disposePreferencesForActiveSimulations(viewId);
                    GraphMapRegistry.getInstance().unRegisterView(GraphMapView.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        this.geographicViewer.setInput(null);
        GraphMapPreferences.getInstance().saveMasterSettingsToFile();
    }

    @Override
    public void onContextMenuUpdate(MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.getSite().registerContextMenu("org.eclipse.stem.ui.views.geographic.map.context", menuManager, selectionProvider);
    }
}

