/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.RealTimeSequencer;
import org.eclipse.stem.core.sequencer.SequencerFactory;
import org.eclipse.stem.core.sequencer.SequentialSequencer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewSequencerWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class NewSequentialSequencerWizard
extends NewSequencerWizard {

    public static class NewFixedSequentialSequencerWizard
    extends NewSequentialSequencerWizard {
        @Override
        protected String getWizardTitle() {
            return Messages.getString("NSeqSequencerWiz.wizard_title");
        }

        @Override
        protected NewIdentifiablePage createNewIdentifiablePage() {
            this.setHelpContextId("org.eclipse.stem.doc.newsequentialsequencer_contextid");
            return new FixedSequentialSequencerPage();
        }

        @Override
        protected Identifiable createIdentifiable() {
            SequentialSequencer retValue = SequencerFactory.eINSTANCE.createSequentialSequencer();
            retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
            Date startDate = ((FixedSequentialSequencerPage)this.newIdentifiablePage).getStartDate();
            Date endDate = ((FixedSequentialSequencerPage)this.newIdentifiablePage).getEndDate();
            try {
                retValue.setTimeIncrement(((FixedSequentialSequencerPage)this.newIdentifiablePage).getCycleDuration());
                STEMTime startTime = ModelFactory.eINSTANCE.createSTEMTime();
                startTime.setTime(startDate);
                retValue.setStartTime(startTime);
                if (endDate != null) {
                    STEMTime endTime = ModelFactory.eINSTANCE.createSTEMTime();
                    endTime.setTime(endDate);
                    retValue.setEndTime(endTime);
                }
            }
            catch (Exception e) {
                Activator.logError("NewSequentialSequencer", e);
            }
            return retValue;
        }

        @Override
        protected DublinCorePage createDublinCorePage() {
            return new DublinCorePage(){

                @Override
                protected void initializeDCAttributes() {
                    StringBuilder sb = new StringBuilder("start=");
                    sb.append(DublinCoreImpl.createISO8601DateString((Date)((FixedSequentialSequencerPage)NewFixedSequentialSequencerWizard.this.newIdentifiablePage).getStartDate()));
                    sb.append(";");
                    Date endDate = ((FixedSequentialSequencerPage)NewFixedSequentialSequencerWizard.this.newIdentifiablePage).getEndDate();
                    if (endDate != null) {
                        sb.append(" end=");
                        sb.append(DublinCoreImpl.createISO8601DateString((Date)endDate));
                        sb.append(";");
                    }
                    super.initializeDCAttributes();
                    this.format.setText("http:///org/eclipse/stem/core/sequencer.ecore");
                    this.format.setEnabled(false);
                    this.type.setText(STEMURI.SEQUENCER_TYPE_URI.toString());
                    this.type.setEnabled(false);
                    this.titleTextField.setText(Messages.getString("dc_title_seq"));
                    this.source.setText(Messages.getString("dc_source_seq"));
                    this.descriptionTextField.setText(Messages.getString("dc_desc_seq"));
                    this.valid.setText(sb.toString());
                }
            };
        }

        protected static class FixedSequentialSequencerPage
        extends SequentialSequencerPage {
            private static final boolean END_DATE_INITIALLY_ENABLED = false;
            Button endDateEnabledButton;
            private DateTime startDate;
            DateTime endDate;

            protected FixedSequentialSequencerPage() {
            }

            public Date getStartDate() {
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.set(this.startDate.getYear(), this.startDate.getMonth(), this.startDate.getDay(), 12, 0, 0);
                return startCalendar.getTime();
            }

            public Date getEndDate() {
                Date retValue = null;
                if (this.endDateEnabledButton.getSelection()) {
                    Calendar endCalendar = Calendar.getInstance();
                    endCalendar.set(this.endDate.getYear(), this.endDate.getMonth(), this.endDate.getDay(), 11, 59, 59);
                    retValue = endCalendar.getTime();
                }
                return retValue;
            }

            @Override
            protected boolean validatePage() {
                boolean retValue = super.validatePage();
                if (retValue && this.endDateEnabledButton.getSelection()) {
                    if (this.endDate.getYear() < this.startDate.getYear()) {
                        retValue = false;
                    } else if (this.endDate.getYear() == this.startDate.getYear() && this.endDate.getMonth() < this.startDate.getMonth()) {
                        retValue = false;
                    } else if (this.endDate.getYear() == this.startDate.getYear() && this.endDate.getMonth() == this.startDate.getMonth() && this.endDate.getDay() <= this.startDate.getDay()) {
                        retValue = false;
                    }
                    if (!retValue) {
                        this.setErrorMessage(Messages.getString("NSeqSequencerWiz.endBeforeErr"));
                    }
                }
                return retValue;
            }

            @Override
            protected Composite createSequentialSequencerSpecificComposite(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.verticalSpacing = 12;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                composite.setLayout((Layout)layout);
                GridData compositeGridLayoutData = new GridData();
                compositeGridLayoutData.horizontalAlignment = 4;
                composite.setLayoutData((Object)compositeGridLayoutData);
                new Label(composite, 0);
                Label startDateLabel = new Label(composite, 0x1000000);
                startDateLabel.setLayoutData((Object)new GridData());
                startDateLabel.setText(String.valueOf(Messages.getString("NSeqSequencerWiz.startTime")) + ":");
                new Label(composite, 0);
                this.startDate = new DateTime(composite, 1024);
                this.startDate.setLayoutData((Object)new GridData());
                this.startDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                new Label(composite, 0);
                this.endDateEnabledButton = new Button(composite, 32);
                this.endDateEnabledButton.setText(String.valueOf(Messages.getString("NSeqSequencerWiz.endTime")) + ":");
                this.endDateEnabledButton.setLayoutData((Object)new GridData());
                this.endDateEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FixedSequentialSequencerPage.this.endDate.setEnabled(FixedSequentialSequencerPage.this.endDateEnabledButton.getSelection());
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                new Label(composite, 0);
                this.endDate = new DateTime(composite, 1024);
                this.endDate.setEnabled(false);
                this.endDate.setLayoutData((Object)new GridData());
                this.endDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                return composite;
            }
        }

        public static class NewSequentialSequencerWizardCommandHandler
        extends AbstractHandler
        implements IHandler {
            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                NewFixedSequentialSequencerWizard wizard = new NewFixedSequentialSequencerWizard();
                wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
                wizardDialog.open();
                return null;
            }
        }
    }

    public static class NewRealTimeSequencerWizard
    extends NewSequentialSequencerWizard {
        @Override
        protected String getWizardTitle() {
            return Messages.getString("NRTSequencerWiz.wizard_title");
        }

        @Override
        protected NewIdentifiablePage createNewIdentifiablePage() {
            this.setHelpContextId("org.eclipse.stem.doc.newrealtimesequencer_contextid");
            return new RealTimeSequentialSequencerPage();
        }

        @Override
        protected Identifiable createIdentifiable() {
            RealTimeSequencer retValue = SequencerFactory.eINSTANCE.createRealTimeSequencer();
            retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
            retValue.setTimeIncrement(((RealTimeSequentialSequencerPage)this.newIdentifiablePage).getCycleDuration());
            return retValue;
        }

        public static class NewRealTimeSequencerWizardCommandHandler
        extends AbstractHandler
        implements IHandler {
            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                NewRealTimeSequencerWizard wizard = new NewRealTimeSequencerWizard();
                wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
                wizardDialog.open();
                return null;
            }
        }

        protected static class RealTimeSequentialSequencerPage
        extends SequentialSequencerPage {
            protected RealTimeSequentialSequencerPage() {
            }

            @Override
            protected Composite createSequentialSequencerSpecificComposite(Composite parent) {
                Composite composite = new Composite(parent, 0);
                return composite;
            }

            @Override
            protected Composite createSpecificComposite(Composite parent) {
                Composite composite = super.createSpecificComposite(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newrealtimesequencer_contextid");
                return composite;
            }
        }
    }

    protected static abstract class SequentialSequencerPage
    extends NewSequencerWizard.SequencerPage {
        protected static final String DEFAULT_CYCLE_PERIOD_TIME_VALUE = "1";
        private static final STEMTime.Units DEFAULT_CYCLE_PERIOD_TIME_UNIT = STEMTime.Units.DAY;
        private static final String[] cyclePeriodTimeUnitStringsPlural = new String[]{Messages.getString("NSequencerWiz.milliseconds"), Messages.getString("NSequencerWiz.seconds"), Messages.getString("NSequencerWiz.minutes"), Messages.getString("NSequencerWiz.hours"), Messages.getString("NSequencerWiz.days"), Messages.getString("NSequencerWiz.weeks"), Messages.getString("NSequencerWiz.months"), Messages.getString("NSequencerWiz.years")};
        private static final String[] cyclePeriodTimeUnitStringsSingular = new String[]{Messages.getString("NSequencerWiz.millisecond"), Messages.getString("NSequencerWiz.second"), Messages.getString("NSequencerWiz.minute"), Messages.getString("NSequencerWiz.hour"), Messages.getString("NSequencerWiz.day"), Messages.getString("NSequencerWiz.weeks"), Messages.getString("NSequencerWiz.years")};
        private Text cyclePeriodTimeValueField;
        private Combo cyclePeriodTimeComboBox;

        public SequentialSequencerPage() {
            super(Messages.getString("NSeqSequencerWiz.page_title"));
            this.setTitle(Messages.getString("NSeqSequencerWiz.page_title"));
            this.setDescription(Messages.getString("NSeqSequencerWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 12;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            GridData compositeGridLayoutData = new GridData();
            compositeGridLayoutData.horizontalAlignment = 4;
            composite.setLayoutData((Object)compositeGridLayoutData);
            Label cycleTimeLabel = new Label(composite, 0);
            cycleTimeLabel.setText(String.valueOf(Messages.getString("NSequencerWiz.cycleTime")) + ":");
            GridData cycleTimeLabelLayoutData = new GridData();
            cycleTimeLabelLayoutData.horizontalSpan = 1;
            cycleTimeLabelLayoutData.horizontalAlignment = 16384;
            cycleTimeLabel.setLayoutData((Object)cycleTimeLabelLayoutData);
            this.cyclePeriodTimeValueField = new Text(composite, 2048);
            this.cyclePeriodTimeValueField.setText(DEFAULT_CYCLE_PERIOD_TIME_VALUE);
            GridData cycleTimeValueLayoutData = new GridData();
            cycleTimeValueLayoutData.horizontalAlignment = 4;
            cycleTimeValueLayoutData.grabExcessHorizontalSpace = true;
            cycleTimeValueLayoutData.horizontalSpan = 1;
            this.cyclePeriodTimeValueField.setLayoutData((Object)cycleTimeValueLayoutData);
            this.cyclePeriodTimeValueField.addModifyListener(this.projectValidator);
            this.cyclePeriodTimeComboBox = new Combo(composite, 12);
            this.cyclePeriodTimeComboBox.setItems(cyclePeriodTimeUnitStringsPlural);
            this.cyclePeriodTimeComboBox.select(DEFAULT_CYCLE_PERIOD_TIME_UNIT.ordinal());
            GridData cycleTimeComboBoxLayoutData = new GridData();
            cycleTimeComboBoxLayoutData.horizontalAlignment = 131072;
            cycleTimeComboBoxLayoutData.horizontalSpan = 1;
            this.cyclePeriodTimeComboBox.setLayoutData((Object)cycleTimeComboBoxLayoutData);
            Composite sequencerSpecificControl = this.createSequentialSequencerSpecificComposite(composite);
            GridData sequencerSpecificControlLayoutData = new GridData();
            sequencerSpecificControlLayoutData.horizontalAlignment = 4;
            sequencerSpecificControlLayoutData.grabExcessHorizontalSpace = true;
            sequencerSpecificControlLayoutData.horizontalSpan = 2;
            sequencerSpecificControl.setLayoutData((Object)sequencerSpecificControlLayoutData);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newsequentialsequencer_contextid");
            return composite;
        }

        @Override
        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                try {
                    double cycleTimeValue = Double.parseDouble(this.cyclePeriodTimeValueField.getText());
                    if (cycleTimeValue < 1.0E-10) {
                        retValue = false;
                        this.setErrorMessage(Messages.getString("NSeqSequencerWiz.cycleTimeErr"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    retValue = false;
                    this.setErrorMessage(Messages.getString("NSeqSequencerWiz.cycleTimeFormatErr"));
                }
            }
            return retValue;
        }

        protected long getCycleDuration() {
            long retValue = 1L;
            String cyclePeriodTimeString = this.cyclePeriodTimeValueField.getText();
            long cycleDuration = STEMTime.Units.values()[this.cyclePeriodTimeComboBox.getSelectionIndex()].getMilliseconds();
            try {
                double cycleTimeValue = Double.parseDouble(cyclePeriodTimeString);
                retValue = (long)(cycleTimeValue * (double)cycleDuration);
            }
            catch (Exception e) {
                Activator.logError("NewRealTimeSequentialSequencer", e);
            }
            return retValue;
        }

        protected String getCycleDurationDescription() {
            String cyclePeriodTimeString = this.cyclePeriodTimeValueField.getText();
            StringBuilder sb = new StringBuilder(cyclePeriodTimeString);
            sb.append(" ");
            sb.append(DEFAULT_CYCLE_PERIOD_TIME_VALUE.equals(cyclePeriodTimeString) ? cyclePeriodTimeUnitStringsSingular[this.cyclePeriodTimeComboBox.getSelectionIndex()] : cyclePeriodTimeUnitStringsPlural[this.cyclePeriodTimeComboBox.getSelectionIndex()]);
            return sb.toString();
        }

        protected abstract Composite createSequentialSequencerSpecificComposite(Composite var1);
    }
}

