/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;

public class ApiBaselineWizard
extends Wizard {
    private IApiBaseline profile = null;
    private boolean content = false;

    public ApiBaselineWizard(IApiBaseline profile) {
        this.profile = profile;
        if (profile == null) {
            this.setWindowTitle(WizardMessages.ApiProfileWizard_0);
        } else {
            this.setWindowTitle(WizardMessages.ApiProfileWizard_1);
        }
        this.setNeedsProgressMonitor(true);
    }

    public IApiBaseline getProfile() {
        return this.profile;
    }

    public boolean contentChanged() {
        return this.content;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ApiBaselineWizardPage(this.profile));
    }

    public boolean performFinish() {
        try {
            ApiBaselineWizardPage page = (ApiBaselineWizardPage)this.getContainer().getCurrentPage();
            this.profile = page.finish();
            this.content = page.contentChanged();
            return this.profile != null;
        }
        catch (IOException e) {
            ApiUIPlugin.log(e);
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        return false;
    }

    public boolean performCancel() {
        ApiBaselineWizardPage page = (ApiBaselineWizardPage)this.getContainer().getCurrentPage();
        page.cancel();
        return super.performCancel();
    }
}

