/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;

public class ApiAnnotations
implements IApiAnnotations {
    public static final int VISIBILITY_MASK = 15;
    public static final int RESTRICTIONS_MASK = 496;
    public static final int OFFSET_VISIBILITY = 0;
    public static final int OFFSET_RESTRICTIONS = 4;
    private int bits;

    public ApiAnnotations(int visibility, int restrictions) {
        this.bits = visibility << 0 | restrictions << 4;
    }

    public int getRestrictions() {
        return (this.bits & 0x1F0) >> 4;
    }

    public int getVisibility() {
        return (this.bits & 0xF) >> 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(VisibilityModifiers.getVisibilityName(this.getVisibility()));
        buffer.append(" / ");
        int restrictions = this.getRestrictions();
        buffer.append(RestrictionModifiers.getRestrictionText(restrictions));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApiAnnotations) {
            ApiAnnotations desc = (ApiAnnotations)obj;
            return this.bits == desc.bits;
        }
        return false;
    }

    public int hashCode() {
        return this.bits;
    }
}

