/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingTypeArgumentDecorator
extends TypeArgumentContextProvider
implements TypeArgumentContextProvider.IInitializableTypeArgumentContext,
TypeArgumentContextProvider.Request {
    private static final Logger primaryLog = Logger.getLogger((String)(String.valueOf(LoggingTypeArgumentDecorator.class.getCanonicalName()) + ".Primary"));
    private static final Logger requestLogger = Logger.getLogger((String)(String.valueOf(LoggingTypeArgumentDecorator.class.getCanonicalName()) + ".Request"));
    private String indentation = "";
    private final TypeArgumentContextProvider.IInitializableTypeArgumentContext contextDelegate;
    private TypeArgumentContextProvider.Request requestDelegate;
    private TypeArgumentContextProvider contextProviderDelegate;

    public static boolean isDebugEnabled() {
        return primaryLog.isDebugEnabled() || requestLogger.isDebugEnabled();
    }

    protected void indent() {
        this.indentation = String.valueOf(this.indentation) + "  ";
    }

    protected void dedent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    public LoggingTypeArgumentDecorator(TypeArgumentContextProvider.IInitializableTypeArgumentContext contextDelegate) {
        this.contextDelegate = contextDelegate;
    }

    @Override
    public void initialize(TypeArgumentContextProvider.Request request, TypeArgumentContextProvider contextProvider) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "Initialized argument context for request " + request));
        }
        this.contextProviderDelegate = contextProvider;
        this.requestDelegate = request;
        this.contextDelegate.initialize(this, this);
    }

    @Override
    public JvmTypeReference getBoundArgument(JvmTypeParameter parameter) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getBoundArgument(" + parameter + ")"));
            this.indent();
        }
        JvmTypeReference result = this.contextDelegate.getBoundArgument(parameter);
        if (primaryLog.isDebugEnabled()) {
            this.dedent();
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getBoundArgument.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference getLowerBound(JvmTypeReference reference) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getLowerBound(" + reference + ")"));
            this.indent();
        }
        JvmTypeReference result = this.contextDelegate.getLowerBound(reference);
        if (primaryLog.isDebugEnabled()) {
            this.dedent();
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getLowerBound.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference getUpperBound(JvmTypeReference reference, Notifier context) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getUpperBound(" + reference + ",..)"));
            this.indent();
        }
        JvmTypeReference result = this.contextDelegate.getUpperBound(reference, context);
        if (primaryLog.isDebugEnabled()) {
            this.dedent();
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "getUpperBound.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference resolve(JvmTypeReference reference) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "resolve(" + reference + ")"));
            this.indent();
        }
        JvmTypeReference result = this.contextDelegate.resolve(reference);
        if (primaryLog.isDebugEnabled()) {
            this.dedent();
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "resolve.result = " + result));
        }
        return result;
    }

    @Override
    public boolean isRawTypeContext() {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "isRawTypeContext()"));
            this.indent();
        }
        boolean result = this.contextDelegate.isRawTypeContext();
        if (primaryLog.isDebugEnabled()) {
            this.dedent();
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "isRawTypeContext.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference getReceiverType() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getReceiverType()"));
            this.indent();
        }
        JvmTypeReference result = this.requestDelegate.getReceiverType();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getReceiverType.result = " + result));
        }
        return result;
    }

    @Override
    public JvmFeature getFeature() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getFeature()"));
            this.indent();
        }
        JvmFeature result = this.requestDelegate.getFeature();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getFeature.result = " + this.getIdentifier(result)));
        }
        return result;
    }

    protected String getIdentifier(JvmIdentifiableElement identifiable) {
        if (identifiable == null) {
            return "/null/";
        }
        return identifiable.getIdentifier();
    }

    @Override
    public JvmTypeParameterDeclarator getNearestDeclarator() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getNearestDeclarator()"));
            this.indent();
        }
        JvmTypeParameterDeclarator result = this.requestDelegate.getNearestDeclarator();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getNearestDeclarator.result = " + result));
        }
        return result;
    }

    @Override
    public List<JvmTypeReference> getArgumentTypes() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getArgumentTypes()"));
            this.indent();
        }
        List<JvmTypeReference> result = this.requestDelegate.getArgumentTypes();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getArgumentTypes.result = " + result));
        }
        return result;
    }

    @Override
    public List<JvmTypeReference> getExplicitTypeArgument() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getExplicitTypeArgument()"));
            this.indent();
        }
        List<JvmTypeReference> result = this.requestDelegate.getExplicitTypeArgument();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getExplicitTypeArgument.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference getExpectedType() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getExpectedType()"));
            this.indent();
        }
        JvmTypeReference result = this.requestDelegate.getExpectedType();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getExpectedType.result = " + result));
        }
        return result;
    }

    @Override
    public JvmTypeReference getDeclaredType() {
        if (requestLogger.isDebugEnabled()) {
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getDeclaredType()"));
            this.indent();
        }
        JvmTypeReference result = this.requestDelegate.getDeclaredType();
        if (requestLogger.isDebugEnabled()) {
            this.dedent();
            requestLogger.debug((Object)(String.valueOf(this.indentation) + "getDeclaredType.result = " + result));
        }
        return result;
    }

    @Override
    protected ITypeArgumentContext getDeclaredBoundsContext(JvmExecutable feature) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "compute declared bounds context for " + this.getIdentifier(feature)));
        }
        return this.contextProviderDelegate.getDeclaredBoundsContext(feature);
    }

    @Override
    protected ITypeArgumentContext getExpectedTypeContext(JvmTypeReference declaredType, JvmTypeReference expectedType) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "compute expected type context for " + expectedType + " <= " + declaredType));
        }
        return this.contextProviderDelegate.getExpectedTypeContext(declaredType, expectedType);
    }

    @Override
    protected ITypeArgumentContext getExplicitArgumentContext(JvmExecutable executable, List<JvmTypeReference> explicitTypeArguments) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "compute explicit argument context for " + explicitTypeArguments + " " + this.getIdentifier(executable)));
        }
        return this.contextProviderDelegate.getExplicitArgumentContext(executable, explicitTypeArguments);
    }

    @Override
    protected ITypeArgumentContext getParameterContext(JvmExecutable executable, List<JvmTypeReference> argumentTypes) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "compute parameter context for " + this.getIdentifier(executable) + " with " + argumentTypes));
        }
        return this.contextProviderDelegate.getParameterContext(executable, argumentTypes);
    }

    @Override
    protected TypeArgumentContext getReceiverContext(JvmTypeReference receiverType) {
        if (primaryLog.isDebugEnabled()) {
            primaryLog.debug((Object)(String.valueOf(this.indentation) + "compute receiver context for " + receiverType));
        }
        return this.contextProviderDelegate.getReceiverContext(receiverType);
    }
}

