/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KmlDisplayCustom
implements IKmlDisplay {
    @Override
    public void generatePolygons(String controlFileName, Map<String, GEData> geData, Aspect aspect) {
        GELog.debug(this, "generatePolygons: aspect=" + aspect + " number=" + geData.size());
        KmlDoc kml = new KmlDoc();
        Document doc = kml.getDocument();
        Element root = kml.setRoot(null);
        Element document = kml.appendElement(root, "Document");
        Style[] styles = this.setupStyles(kml, document, aspect);
        int max = styles.length;
        PlaceMark[] placeMark = new PlaceMark[max];
        Element[] multiGeometry = new Element[max];
        int j = 0;
        while (j < max) {
            placeMark[j] = new PlaceMark(doc);
            document.appendChild(placeMark[j].getElement());
            placeMark[j].setDescription("STEM map");
            placeMark[j].setName("STEM" + j);
            placeMark[j].setStyleUrl(styles[j]);
            multiGeometry[j] = doc.createElement("MultiGeometry");
            placeMark[j].appendChild(multiGeometry[j]);
            ++j;
        }
        Iterator<Map.Entry<String, GEData>> it = geData.entrySet().iterator();
        while (it.hasNext()) {
            int type = 0;
            Map.Entry<String, GEData> e = it.next();
            GEData data = e.getValue();
            String county = data.getName();
            type = this.filter(data) ? 0 : this.selectByValue(data);
            if (type < 0) continue;
            int i = 0;
            while (i < data.getNumAreas()) {
                String coord = data.getCoordinatesAsString(i);
                Polygon polygon = new Polygon(doc);
                kml.appendText(polygon.getElement(), "name", county);
                polygon.setCoordinates(coord);
                multiGeometry[type].appendChild(polygon.getElement());
                ++i;
            }
        }
        kml.writeFile(controlFileName);
    }

    private boolean filter(GEData data) {
        boolean filtered = false;
        if (GEPreferencePage.isTest()) {
            String county = data.getName();
            filtered = county.indexOf(" US-") >= 0 ? false : county.indexOf(" MEX") < 0;
        }
        return filtered;
    }

    private Style[] setupStyles(KmlDoc kml, Element document, Aspect aspect) {
        Document doc = kml.getDocument();
        boolean outline = false;
        int max = 9;
        Style[] styles = new Style[max];
        int k = 0;
        while (k < max) {
            styles[k] = new Style(doc, "Style" + k);
            styles[k].setLineStyle(0.3);
            document.appendChild(styles[k].getElement());
            int oo = 160;
            int blue = 0;
            int red = 0;
            int green = 0;
            switch (k) {
                case 0: {
                    red = 240;
                    break;
                }
                case 1: {
                    red = 240;
                    green = 160;
                    break;
                }
                case 2: {
                    red = 208;
                    green = 240;
                    break;
                }
                case 3: {
                    red = 208;
                    green = 176;
                    break;
                }
                case 4: {
                    red = 176;
                    green = 240;
                    break;
                }
                case 5: {
                    red = 240;
                    green = 192;
                    break;
                }
                case 6: {
                    red = 192;
                    green = 240;
                    break;
                }
                case 7: {
                    red = 240;
                    green = 240;
                    break;
                }
                case 8: {
                    red = 0;
                    green = 240;
                    break;
                }
            }
            String hex = String.valueOf(StemKml.getHex(oo)) + StemKml.getHex(blue) + StemKml.getHex(green) + StemKml.getHex(red);
            styles[k].setPolyStyle(hex, outline);
            ++k;
        }
        return styles;
    }

    public int selectByValue(GEData geData) {
        int type = 0;
        double s = geData.getValueMap().get("S");
        double e = geData.getValueMap().get("E");
        double i = geData.getValueMap().get("I");
        double r = geData.getValueMap().get("R");
        type = s == 1.0 && e == 0.0 && i == 0.0 && r == 0.0 ? -1 : (i >= 0.2 ? 0 : (i >= 0.1 ? (e >= r ? 1 : (r > 0.9 ? 8 : 0)) : (i > 0.01 ? (e >= r ? 1 : 8) : (e >= r ? 7 : 8))));
        if (geData.getName().contains(" 25017")) {
            GELog.debug(this, String.valueOf(geData.getName()) + " " + geData.getValuesAsString() + " " + type);
        }
        return type;
    }
}

