/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.core.data.PatternKey;

public class DateFormatFactory {
    private static final int NO_TIME_STYLE = -999;
    private static ThreadLocal tlsCache = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private static ThreadLocal patternCache = new ThreadLocal(){

        protected Object initialValue() {
            HashMap<PatternKey, SimpleDateFormat> value = new HashMap<PatternKey, SimpleDateFormat>();
            String[] dateFormatPattern = new String[]{"yyyy-MM-dd HH:mm:ss.SSS z", "yyyy-MM-dd HH:mm:ss.SSS Z", "yyyy-MM-dd HH:mm:ss.SSSz", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss Z", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mm Z", "yyyy-MM-dd HH:mmz", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy", "HH:mm:ss.SSS"};
            SimpleDateFormat simpleDateFormatter = null;
            PatternKey patterKey = null;
            int i = 0;
            while (i < dateFormatPattern.length) {
                patterKey = PatternKey.getPatterKey(dateFormatPattern[i]);
                simpleDateFormatter = new SimpleDateFormat(dateFormatPattern[i]);
                simpleDateFormatter.setLenient(false);
                value.put(patterKey, simpleDateFormatter);
                ++i;
            }
            return value;
        }
    };

    public static DateFormat getDateTimeInstance(int dateStyle, int timeStyle, ULocale locale) {
        assert (locale != null);
        String keyStr = String.valueOf(locale.getName()) + "/" + Integer.toString(dateStyle) + "/" + Integer.toString(timeStyle);
        HashMap tlsMap = (HashMap)tlsCache.get();
        assert (tlsMap != null);
        DateFormat result = (DateFormat)tlsMap.get(keyStr);
        if (result == null) {
            result = timeStyle == -999 ? DateFormat.getDateInstance((int)dateStyle, (Locale)locale.toLocale()) : DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (Locale)locale.toLocale());
            result.setLenient(false);
            tlsMap.put(keyStr, result);
        }
        return result;
    }

    public static DateFormat getDateInstance(int dateStyle, ULocale locale) {
        return DateFormatFactory.getDateTimeInstance(dateStyle, -999, locale);
    }

    public static SimpleDateFormat getPatternInstance(PatternKey pattern) {
        HashMap patternMap = (HashMap)patternCache.get();
        assert (patternMap != null);
        return (SimpleDateFormat)patternMap.get(pattern);
    }
}

