/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MultiMainTypeSelectionDialog
extends ElementListSelectionDialog {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fStyle;

    public MultiMainTypeSelectionDialog(Shell shell, IRunnableContext context, IJavaSearchScope scope, int style) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(2114));
        this.setMultipleSelection(true);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fStyle = style;
    }

    public int open() {
        Object[] types;
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        try {
            types = engine.searchMainMethods(this.fRunnableContext, this.fScope, this.fStyle);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.MultiMainTypeSelectionDialog_errorTitle, e.getMessage());
            return 1;
        }
        this.setElements(types);
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.multi_main_type_selection_dialog_context");
    }
}

