/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class IdentifiableDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData transferType) {
        boolean retValue = LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
        return retValue;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        IStatus retValue = Status.CANCEL_STATUS;
        if (event.data instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)event.data).toList()) {
                if (!(obj instanceof String)) continue;
                String uriString = (String)obj;
                try {
                    URI uri = URI.createURI((String)uriString);
                    Identifiable identifable = Utility.getIdentifiable((URI)uri);
                    if (identifable instanceof Scenario) {
                        return retValue;
                    }
                    ArrayList<Identifiable> resourcesToSave = new ArrayList<Identifiable>();
                    Identifiable identifiableCopy = this.copy(identifable, resourcesToSave);
                    resourcesToSave.remove(resourcesToSave.size() - 1);
                    resourcesToSave.add(0, identifiableCopy);
                    DublinCore dc = identifiableCopy.getDublinCore();
                    URI serializationURI = this.createSerializationURI(uri, (IdentifiableTreeNode)target);
                    identifiableCopy.setURI(serializationURI);
                    dc.setTitle("Copy of \"" + dc.getTitle() + "\"");
                    dc.setDescription("Copy of \"" + dc.getDescription() + "\"");
                    dc.populate();
                    Utility.serializeIdentifiables(resourcesToSave, (URI)serializationURI);
                    retValue = Status.OK_STATUS;
                }
                catch (Exception e) {
                    Activator.logError("Problem deserializing Identifiable from \"" + uriString + "\"", e);
                }
            }
        }
        return retValue;
    }

    private Identifiable copy(Identifiable ident, List<Identifiable> resourcesToSave) {
        if (ident instanceof Model) {
            Model m = (Model)EcoreUtil.copy((EObject)ident);
            Collection subModels = EcoreUtil.copyAll((Collection)m.getModels());
            m.getModels().clear();
            for (Model sm : subModels) {
                Model newModel = (Model)this.copy((Identifiable)sm, resourcesToSave);
                m.getModels().add((Object)newModel);
            }
            Collection subGraphs = EcoreUtil.copyAll((Collection)m.getGraphs());
            m.getGraphs().clear();
            for (Graph sg : subGraphs) {
                Graph g = (Graph)this.copy((Identifiable)sg, resourcesToSave);
                m.getGraphs().add((Object)g);
            }
            resourcesToSave.add((Identifiable)m);
            return m;
        }
        Identifiable ci = (Identifiable)EcoreUtil.copy((EObject)ident);
        resourcesToSave.add(ci);
        return ci;
    }

    private URI createSerializationURI(URI uri, IdentifiableTreeNode treeNode) {
        StringBuilder sb = new StringBuilder(treeNode.getProject().getName());
        sb.append("/");
        sb.append(treeNode.getFolderName());
        sb.append("/");
        sb.append(uri.segment(uri.segmentCount() - 1));
        return URI.createPlatformResourceURI((String)sb.toString(), (boolean)false);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        return Status.OK_STATUS;
    }
}

