/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.editors.validation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.editors.validation.ConstraintValidationHandler;
import org.eclipse.stem.ui.editors.validation.InvalidConstraintException;
import org.eclipse.stem.ui.editors.validation.MaxValueConstraintValidationHandler;
import org.eclipse.stem.ui.editors.validation.MinValueConstraintValidationHandler;

public class EAnnotationConstraintValidator {
    private static final Map<String, Class<? extends ConstraintValidationHandler>> HANDLERS = new HashMap<String, Class<? extends ConstraintValidationHandler>>();
    EAnnotation annotation;
    List<ConstraintValidationHandler> validators;

    static {
        HANDLERS.put("minValue", MinValueConstraintValidationHandler.class);
        HANDLERS.put("maxValue", MaxValueConstraintValidationHandler.class);
    }

    public EAnnotationConstraintValidator(EAnnotation annotation) {
        this.annotation = annotation;
        this.createValidators();
    }

    protected void createValidators() {
        this.validators = new LinkedList<ConstraintValidationHandler>();
        if (this.annotation != null) {
            for (Map.Entry constraint : this.annotation.getDetails()) {
                try {
                    Class<? extends ConstraintValidationHandler> clazz = HANDLERS.get(constraint.getKey());
                    if (clazz == null) {
                        Activator.logWarning("Constraint validation handler for " + (String)constraint.getKey() + " not available", null);
                        continue;
                    }
                    ConstraintValidationHandler handler = clazz.getConstructor(String.class).newInstance(constraint.getValue());
                    this.validators.add(handler);
                }
                catch (InvalidConstraintException ive) {
                    Activator.logWarning("Invalid constraint for handler " + (String)constraint.getKey() + " specified: " + (String)constraint.getValue(), ive);
                }
                catch (Exception e) {
                    Activator.logWarning("Error initializing the constraint validation handler for " + (String)constraint.getKey(), e);
                }
            }
        }
    }

    protected List<ConstraintValidationHandler> getValidators() {
        return this.validators;
    }

    public boolean validate(String value) {
        for (ConstraintValidationHandler handler : this.getValidators()) {
            if (handler.validate(value)) continue;
            return false;
        }
        return true;
    }
}

