/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.diseasemodels.forcing.presentation;

import org.eclipse.core.resources.IProject;
import org.eclipse.stem.diseasemodels.forcing.ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.forcing.Gaussian2ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.Gaussian3ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.GaussianForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.diseasemodels.forcing.presentation.ForcingDiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.StandardDiseaseModelPropertyEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ForcingDiseaseModelPropertyEditor
extends StandardDiseaseModelPropertyEditor {
    public ForcingDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
    }

    public void populate(DiseaseModel diseaseModel) {
        ForcingDiseaseModel model;
        super.populate(diseaseModel);
        if (diseaseModel instanceof ForcingDiseaseModel) {
            model = (ForcingDiseaseModel)diseaseModel;
            model.setModulationExponent(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_EXPONENT)).getText()));
            model.setModulationPeriod(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_PERIOD)).getText()));
            model.setModulationPhaseShift(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_PHASE_SHIFT)).getText()));
            model.setModulationFloor(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_FLOOR)).getText()));
        }
        if (diseaseModel instanceof GaussianForcingDiseaseModel) {
            model = (GaussianForcingDiseaseModel)diseaseModel;
            model.setSigma2(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__SIGMA2)).getText()));
            model.setModulationPeriod(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_PERIOD)).getText()));
            model.setModulationPhaseShift(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_PHASE_SHIFT)).getText()));
            model.setModulationFloor(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_FLOOR)).getText()));
        }
        if (diseaseModel instanceof Gaussian2ForcingDiseaseModel) {
            model = (Gaussian2ForcingDiseaseModel)diseaseModel;
            model.setSigma2_2(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__SIGMA2_2)).getText()));
            model.setAtt1(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT1)).getText()));
            model.setAtt2(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT2)).getText()));
            model.setAtt3(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT3)).getText()));
            model.setAtt4(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT4)).getText()));
        }
        if (diseaseModel instanceof Gaussian3ForcingDiseaseModel) {
            model = (Gaussian3ForcingDiseaseModel)diseaseModel;
            model.setSigma2_3(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__SIGMA2_3)).getText()));
            model.setTransmissionRate2(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__TRANSMISSION_RATE2)).getText()));
            model.setTransmissionRate3(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__TRANSMISSION_RATE3)).getText()));
            model.setModulationFloor_2(Double.parseDouble(((Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__MODULATION_FLOOR_2)).getText()));
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_EXPONENT);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationExponentMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationExponentINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPeriodMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPeriodINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_PHASE_SHIFT)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPhaseMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPhaseINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.FORCING_DISEASE_MODEL__MODULATION_FLOOR)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloorMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloorINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__SIGMA2)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPeriodMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPeriodINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_PHASE_SHIFT)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPhaseMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationPhaseINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL__MODULATION_FLOOR)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloorMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloorINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT1)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att1MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att1INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT2)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att2MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att2INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT3)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att3MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att3INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__ATT4)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att4MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("att4INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL__SIGMA2_2)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2_2MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2_2INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__SIGMA2_3)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2_3MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("sigma2_3INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__TRANSMISSION_RATE2)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("transmissionRate2MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("transmissionRate2INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__TRANSMISSION_RATE3)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("transmissionRate3MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("transmissionRate3INVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL__MODULATION_FLOOR_2)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloor_2MISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ForcingDiseaseWizardMessages.getString("modulationFloor_2INVALID");
                return false;
            }
        }
        return true;
    }
}

