/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.Verifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.verifier.CertVerificationResult;

public class CertVerifier
extends Verifier {
    private CertVerificationResult result;
    private boolean acceptUnsignedFiles;
    private IProgressMonitor monitor;
    private File jarFile;
    private SignedContentFactory factory;
    private List trustedSignerInfos;

    public CertVerifier(SignedContentFactory factory) {
        this.factory = factory;
        this.initialize();
    }

    private void initialize() {
        this.result = null;
        this.acceptUnsignedFiles = false;
    }

    private void init(IFeature feature, ContentReference contentRef) throws CoreException {
        this.jarFile = null;
        if (contentRef instanceof JarContentReference) {
            JarContentReference jarReference = (JarContentReference)contentRef;
            try {
                this.jarFile = jarReference.asFile();
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("Attempting to read JAR file:" + this.jarFile);
                }
                if (!this.jarFile.exists()) {
                    throw new IOException();
                }
                JarFile jar = new JarFile(this.jarFile);
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ZipException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_InvalidJar, (Object[])new String[]{jarReference.toString()}), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToAccessJar, (Object[])new String[]{jarReference.toString()}), e);
            }
        }
        this.result = new CertVerificationResult();
        this.result.setVerificationCode(6);
        this.result.setResultException(null);
        this.result.setFeature(feature);
        this.result.setContentReference(contentRef);
    }

    private void setMonitor(IProgressMonitor newMonitor) {
        this.monitor = newMonitor;
    }

    public IVerificationResult verify(IFeature feature, ContentReference reference, boolean isFeatureVerification, InstallMonitor monitor) throws CoreException {
        IVerificationResult vr;
        if (reference == null) {
            return this.result;
        }
        if (this.getParent() != null && (vr = this.getParent().verify(feature, reference, isFeatureVerification, monitor)).getVerificationCode() != 8) {
            return vr;
        }
        this.setMonitor(monitor);
        this.init(feature, reference);
        this.result.isFeatureVerification(isFeatureVerification);
        if (this.jarFile != null) {
            this.result = this.verify(this.jarFile.getAbsolutePath(), reference.getIdentifier());
        } else {
            this.result.setVerificationCode(8);
        }
        return this.result;
    }

    private CertVerificationResult verify(String file, String identifier) {
        try {
            SignedContent verifier = this.factory.getSignedContent(new File(file));
            this.verifyIntegrity(verifier, identifier);
            this.result.alreadySeen(this.alreadyValidated());
            if (this.result.getVerificationCode() == 1) {
                this.acceptUnsignedFiles = true;
            }
        }
        catch (Exception e) {
            this.result.setVerificationCode(6);
            this.result.setResultException(e);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
            if (this.monitor.isCanceled()) {
                this.result.setVerificationCode(7);
            }
        }
        return this.result;
    }

    private void verifyIntegrity(SignedContent verifier, String identifier) {
        block8: {
            try {
                if (verifier.isSigned()) {
                    if (this.hasValidContent(verifier.getSignedEntries())) {
                        this.result.setSignedContent(verifier);
                        SignerInfo[] signers = verifier.getSignerInfos();
                        int i = 0;
                        while (i < signers.length) {
                            if (signers[i].isTrusted()) {
                                this.result.setVerificationCode(3);
                                break;
                            }
                            ++i;
                        }
                        if (this.result.getVerificationCode() != 3) {
                            this.result.setVerificationCode(5);
                        }
                    } else {
                        this.result.setVerificationCode(2);
                    }
                    break block8;
                }
                this.result.setVerificationCode(1);
                return;
            }
            catch (Exception e) {
                this.result.setVerificationCode(6);
                this.result.setResultException(e);
            }
        }
    }

    private boolean hasValidContent(SignedContentEntry[] signedEntries) {
        try {
            int i = 0;
            while (i < signedEntries.length) {
                signedEntries[i].verify();
                ++i;
            }
        }
        catch (InvalidContentException invalidContentException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean alreadyValidated() {
        int verifyCode = this.result.getVerificationCode();
        if (verifyCode == 1) {
            return this.acceptUnsignedFiles;
        }
        if (verifyCode == 6) {
            return false;
        }
        if (this.result.getSigners() != null) {
            Iterator iter = this.getTrustedInfos().iterator();
            SignerInfo[] signers = this.result.getSigners();
            while (iter.hasNext()) {
                SignerInfo chain = (SignerInfo)iter.next();
                int i = 0;
                while (i < signers.length) {
                    if (chain.equals(signers[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < signers.length) {
                this.addTrustedSignerInfo(signers[i]);
                ++i;
            }
        }
        return false;
    }

    private void addTrustedSignerInfo(SignerInfo signer) {
        if (this.trustedSignerInfos == null) {
            this.trustedSignerInfos = new ArrayList();
        }
        if (signer != null) {
            this.trustedSignerInfos.add(signer);
        }
    }

    private List getTrustedInfos() {
        if (this.trustedSignerInfos == null) {
            this.trustedSignerInfos = new ArrayList();
        }
        return this.trustedSignerInfos;
    }

    public void setParent(IVerifier parentVerifier) {
        super.setParent(parentVerifier);
        this.initialize();
    }
}

