/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.inject.ImplementedBy;
import java.util.List;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

@ImplementedBy(value=DefaultImpl.class)
public interface IQualifiedNameConverter {
    public String toString(QualifiedName var1);

    public QualifiedName toQualifiedName(String var1);

    public static class DefaultImpl
    implements IQualifiedNameConverter {
        public String toString(QualifiedName qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            return qualifiedName.toString(this.getDelimiter());
        }

        public QualifiedName toQualifiedName(String qualifiedNameAsString) {
            if (qualifiedNameAsString == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            if (qualifiedNameAsString.equals("")) {
                throw new IllegalArgumentException("Qualified name cannot be empty");
            }
            if (Strings.isEmpty((String)this.getDelimiter())) {
                return QualifiedName.create(qualifiedNameAsString);
            }
            List segs = this.getDelimiter().length() == 1 ? Strings.split((String)qualifiedNameAsString, (char)this.getDelimiter().charAt(0)) : Strings.split((String)qualifiedNameAsString, (String)this.getDelimiter());
            return QualifiedName.create(segs);
        }

        public String getDelimiter() {
            return ".";
        }
    }
}

