/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.diseasemodels.experimental.adapters;

import org.eclipse.core.resources.IProject;
import org.eclipse.stem.diseasemodels.experimental.ExperimentalPackage;
import org.eclipse.stem.diseasemodels.experimental.TBDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.diseasemodels.experimental.adapters.ExperimentalDiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.StandardDiseaseModelPropertyEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ExperimentalDiseaseModelPropertyEditor
extends StandardDiseaseModelPropertyEditor {
    public ExperimentalDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate(diseaseModel);
        if (diseaseModel instanceof TBDiseaseModel) {
            TBDiseaseModel model = (TBDiseaseModel)diseaseModel;
            model.setTransmissionRate(Double.parseDouble(((Text)this.map.get(ExperimentalPackage.Literals.TB_DISEASE_MODEL__TRANSMISSION_RATE)).getText()));
            model.setActiveInfProb(Double.parseDouble(((Text)this.map.get(ExperimentalPackage.Literals.TB_DISEASE_MODEL__ACTIVE_INF_PROB)).getText()));
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(ExperimentalPackage.Literals.TB_DISEASE_MODEL__TRANSMISSION_RATE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExperimentalDiseaseWizardMessages.getString("transmissionRateMissing");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText(), 0.0)) {
                this.errorMessage = ExperimentalDiseaseWizardMessages.getString("transmissionRateInvalid");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ExperimentalPackage.Literals.TB_DISEASE_MODEL__ACTIVE_INF_PROB)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExperimentalDiseaseWizardMessages.getString("activeInfProbMissing");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText(), 0.0, 1.0)) {
                this.errorMessage = ExperimentalDiseaseWizardMessages.getString("activeInfProbInvalid");
                return false;
            }
        }
        return true;
    }
}

