/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.GELog;

public class Aspect {
    private String code = null;
    private String name = null;
    private String description = null;
    public static final String PROPERTIES_NAME = "aspect.properties";
    public static final double[] DEFAULT_RANGE = new double[]{0.0, 0.33, 0.66, 1.0};
    public static final int[] DEFAULT_OPACITY;
    private double[] range = DEFAULT_RANGE;
    private int[] opacity = DEFAULT_OPACITY;
    private int[] red = null;
    private int[] green = null;
    private int[] blue = null;
    private String type = "relative";
    private String unit = null;
    private static Map<String, Aspect> map;
    private static String defaultAspect;
    private static String kmlDisplayClass;
    private static Properties properties;

    static {
        int[] nArray = new int[4];
        nArray[1] = 128;
        nArray[2] = 160;
        nArray[3] = 192;
        DEFAULT_OPACITY = nArray;
        map = null;
        defaultAspect = "";
        kmlDisplayClass = "org.eclipse.stem.ui.ge.kml.KmlDisplay";
        properties = new Properties();
    }

    public static void setup() {
        try {
            InputStream in = Aspect.class.getResourceAsStream(PROPERTIES_NAME);
            if (in != null) {
                properties.load(in);
                map = null;
                Aspect.getAspects(properties);
            } else {
                GELog.error("Failed reading Aspect properties. aspect.properties", null);
                if (map == null) {
                    map = new HashMap<String, Aspect>(5);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getAspects(Properties properties) {
        String list = properties.getProperty("Aspects", "S,E,I,R");
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (defaultAspect == null || defaultAspect.length() == 0) {
                defaultAspect = token;
            }
            String name = properties.getProperty(String.valueOf(token) + ".name", null);
            Aspect aspect = new Aspect(token, name);
            String description = properties.getProperty(String.valueOf(token) + ".description", null);
            aspect.setDescription(description);
            String range = properties.getProperty(String.valueOf(token) + ".range", null);
            aspect.setRange(range);
            String opacity = properties.getProperty(String.valueOf(token) + ".opacity", null);
            aspect.setOpacity(opacity);
            String color = properties.getProperty(String.valueOf(token) + ".red", "0");
            aspect.setRed(color);
            color = properties.getProperty(String.valueOf(token) + ".green", "0");
            aspect.setGreen(color);
            color = properties.getProperty(String.valueOf(token) + ".blue", "0");
            aspect.setBlue(color);
        }
        defaultAspect = properties.getProperty("Default", defaultAspect);
        kmlDisplayClass = properties.getProperty("kmlDisplay", kmlDisplayClass);
    }

    public Aspect(String code, String name) {
        this.code = code;
        this.name = name;
        if (this.red == null) {
            this.setRed("0");
        }
        if (this.green == null) {
            this.setGreen("0");
        }
        if (this.blue == null) {
            this.setBlue("0");
        }
        if (map == null) {
            map = new HashMap<String, Aspect>(5);
        }
        map.put(code, this);
    }

    public boolean isSane() {
        try {
            Assert.isNotNull((Object)this.range);
            int n = this.range.length;
            Assert.isTrue((this.opacity.length == n ? 1 : 0) != 0, (String)"Invalid Opacity dimension");
            Assert.isTrue((this.red.length == n ? 1 : 0) != 0, (String)"Invalid Color Red dimension");
            Assert.isTrue((this.green.length == n ? 1 : 0) != 0, (String)"Invalid Color Blue dimension");
            Assert.isTrue((this.blue.length == n ? 1 : 0) != 0, (String)"Invalid Color Green dimension");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Aspect getAspect(String code) {
        Aspect aspect = null;
        if (map == null) {
            Aspect.setup();
        }
        if (map != null) {
            aspect = map.get(code);
            if (aspect == null) {
                aspect = map.get(defaultAspect);
            }
        } else {
            GELog.error("Invalid condition. Aspect map is null", null);
        }
        return aspect;
    }

    public static boolean exists(String aspectCode) {
        return map.containsKey(aspectCode);
    }

    public static Map<String, Aspect> getMap() {
        return map;
    }

    public static void setMap(Map<String, Aspect> map) {
        Aspect.map = map;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String newcode) {
        map.remove(this.code);
        this.code = newcode;
        map.put(newcode, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.code;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double[] getRange() {
        return this.range;
    }

    public double getRange(int n) {
        return this.range[n];
    }

    public void setRange(String range) {
        if (range == null) {
            this.range = DEFAULT_RANGE;
            return;
        }
        StringTokenizer tokens = new StringTokenizer(range, ",");
        int n = tokens.countTokens();
        this.range = new double[n];
        int i = 0;
        while (i < n) {
            double value;
            this.range[i] = value = Double.parseDouble(tokens.nextToken().trim());
            ++i;
        }
    }

    public int[] getOpacity() {
        return this.opacity;
    }

    public int getOpacity(int n) {
        return this.opacity[n];
    }

    public void setOpacity(String opacity) {
        int n = this.getRange().length;
        this.opacity = new int[n];
        if (opacity == null) {
            this.opacity[0] = 0;
            int i = 1;
            while (i < n) {
                this.opacity[i] = DEFAULT_OPACITY[i];
                ++i;
            }
            return;
        }
        StringTokenizer tokens = new StringTokenizer(opacity, ",");
        int value = 0;
        int i = 0;
        while (i < n) {
            if (tokens.hasMoreTokens()) {
                value = Integer.parseInt(tokens.nextToken().trim());
            }
            this.opacity[i] = value;
            ++i;
        }
    }

    public void setRed(String color) {
        int n = this.getRange().length;
        this.red = new int[n];
        if (color == null) {
            int i = 0;
            while (i < n) {
                this.red[i] = 0;
                ++i;
            }
            return;
        }
        StringTokenizer tokens = new StringTokenizer(color, ",");
        int value = 0;
        int i = 0;
        while (i < n) {
            if (tokens.hasMoreTokens()) {
                value = Integer.parseInt(tokens.nextToken().trim());
            }
            this.red[i] = value;
            ++i;
        }
    }

    public void setGreen(String color) {
        int n = this.getRange().length;
        this.green = new int[n];
        if (color == null) {
            int i = 0;
            while (i < n) {
                this.green[i] = 0;
                ++i;
            }
            return;
        }
        StringTokenizer tokens = new StringTokenizer(color, ",");
        int value = 0;
        int i = 0;
        while (i < n) {
            if (tokens.hasMoreTokens()) {
                value = Integer.parseInt(tokens.nextToken().trim());
            }
            this.green[i] = value;
            ++i;
        }
    }

    public void setBlue(String color) {
        int n = this.getRange().length;
        this.blue = new int[n];
        if (color == null) {
            int i = 0;
            while (i < n) {
                this.blue[i] = 0;
                ++i;
            }
            return;
        }
        StringTokenizer tokens = new StringTokenizer(color, ",");
        int value = 0;
        int i = 0;
        while (i < n) {
            if (tokens.hasMoreTokens()) {
                value = Integer.parseInt(tokens.nextToken());
            }
            this.blue[i] = value;
            ++i;
        }
    }

    public int getRed(int n) {
        return this.red[n];
    }

    public int getGreen(int n) {
        return this.green[n];
    }

    public int getBlue(int n) {
        return this.blue[n];
    }

    public void setRange(double[] range) {
        this.range = range;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Aspect getDefault() {
        String code = Aspect.getDefaultCode();
        return Aspect.getAspect(code);
    }

    public static String getDefaultCode() {
        return defaultAspect;
    }

    public static void setDefaultCode(String defaultAspectCode) {
        defaultAspect = defaultAspectCode;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public static String getKmlDisplayClass() {
        return kmlDisplayClass;
    }

    public static Properties getProperties() {
        return properties;
    }
}

