/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.shp;

import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.input.SwappedDataInputStream;
import org.eclipse.stem.gis.coord.CoordinateSystem;
import org.eclipse.stem.gis.shp.ShpHeader;
import org.eclipse.stem.gis.shp.ShpMultiPatch;
import org.eclipse.stem.gis.shp.ShpMultiPoint;
import org.eclipse.stem.gis.shp.ShpMultiPointM;
import org.eclipse.stem.gis.shp.ShpMultiPointZ;
import org.eclipse.stem.gis.shp.ShpNullShape;
import org.eclipse.stem.gis.shp.ShpPoint;
import org.eclipse.stem.gis.shp.ShpPointM;
import org.eclipse.stem.gis.shp.ShpPointZ;
import org.eclipse.stem.gis.shp.ShpPolyLine;
import org.eclipse.stem.gis.shp.ShpPolyLineM;
import org.eclipse.stem.gis.shp.ShpPolyLineZ;
import org.eclipse.stem.gis.shp.ShpPolygon;
import org.eclipse.stem.gis.shp.ShpPolygonM;
import org.eclipse.stem.gis.shp.ShpPolygonZ;
import org.eclipse.stem.gis.shp.ShpRecord;
import org.eclipse.stem.gis.shp.ShpUnsupportedShape;
import org.eclipse.stem.gis.shp.type.Box;
import org.eclipse.stem.gis.shp.type.Part;
import org.eclipse.stem.gis.shp.type.Range;

public class ShpInputStream
extends SwappedDataInputStream {
    ShpHeader header;
    CoordinateSystem coordinateSystem;

    public ShpInputStream(InputStream input) throws IOException {
        this(input, null);
    }

    public ShpInputStream(InputStream input, CoordinateSystem cs) throws IOException {
        super(input);
        this.coordinateSystem = cs;
        this.readHeader();
    }

    private void readHeader() throws IOException {
        ShpHeader header = new ShpHeader();
        header.fileCode = EndianUtils.swapInteger((int)this.readInt());
        this.skipBytes(20);
        header.fileLength = EndianUtils.swapInteger((int)this.readInt());
        header.version = this.readInt();
        header.shapeType = this.readInt();
        header.xyBounds = this.readBoundingBox(true);
        header.zRange = this.readRange();
        header.mRange = this.readRange();
        this.header = header;
    }

    public ShpRecord readNextRecord() throws IOException {
        ShpRecord shp = null;
        try {
            int recordNumber = EndianUtils.swapInteger((int)this.readInt());
            int contentLength = EndianUtils.swapInteger((int)this.readInt());
            int shpType = this.readInt();
            switch (shpType) {
                case 0: {
                    shp = this.readNullShape();
                    break;
                }
                case 1: {
                    shp = this.readPoint();
                    break;
                }
                case 21: {
                    shp = this.readPointM();
                    break;
                }
                case 11: {
                    shp = this.readPointZ();
                    break;
                }
                case 8: {
                    shp = this.readMultiPoint();
                    break;
                }
                case 28: {
                    shp = this.readMultiPointM();
                    break;
                }
                case 18: {
                    shp = this.readMultiPointZ();
                    break;
                }
                case 3: {
                    shp = this.readPolyLine();
                    break;
                }
                case 23: {
                    shp = this.readPolyLineM();
                    break;
                }
                case 13: {
                    shp = this.readPolyLineZ();
                    break;
                }
                case 5: {
                    shp = this.readPolygon();
                    break;
                }
                case 25: {
                    shp = this.readPolygonM();
                    break;
                }
                case 15: {
                    shp = this.readPolygonZ();
                    break;
                }
                case 31: {
                    shp = this.readMultiPatch();
                    break;
                }
                default: {
                    shp = this.readUnsupportedShape(contentLength - 2);
                }
            }
            shp.setContentLength(contentLength);
            shp.setRecordNumber(recordNumber);
        }
        catch (EOFException eOFException) {
            shp = null;
        }
        return shp;
    }

    public ShpHeader getHeader() {
        return this.header;
    }

    protected ShpPolyLine readPolyLine(ShpPolyLine shape) throws IOException {
        Box bbox = this.readBoundingBox(true);
        shape.setBoundingBox(bbox);
        int numParts = this.readInt();
        int numPoints = this.readInt();
        int[] partIndices = this.readPartBoundaries(numParts);
        int[] partTypes = null;
        if (shape instanceof ShpMultiPatch) {
            partTypes = this.readPartTypes(numParts);
        }
        Part[] parts = this.readParts(numPoints, partIndices, partTypes);
        shape.setParts(parts);
        if (shape instanceof ShpPolyLineZ) {
            ((ShpPolyLineZ)shape).setZRange(this.readRange());
            this.readZCoordinates(parts);
        }
        if (shape instanceof ShpPolyLineM) {
            ((ShpPolyLineM)shape).setMRange(this.readRange());
            this.readMeasures(parts);
        }
        return shape;
    }

    protected ShpMultiPoint readMultiPoint(ShpMultiPoint shape) throws IOException {
        shape.setBoundingBox(this.readBoundingBox(true));
        int numPoints = this.readInt();
        Part[] parts = this.readParts(numPoints, new int[1], null);
        shape.setPart(parts[0]);
        if (shape instanceof ShpMultiPointZ) {
            ((ShpMultiPointZ)shape).setZRange(this.readRange());
            this.readZCoordinates(parts);
        }
        if (shape instanceof ShpMultiPointM) {
            ((ShpMultiPointM)shape).setMRange(this.readRange());
            this.readMeasures(parts);
        }
        return shape;
    }

    protected ShpPoint readPoint(ShpPoint shape) throws IOException {
        shape.setPoints(this.readDouble(), this.readDouble());
        if (shape instanceof ShpPointZ) {
            ((ShpPointZ)shape).setZ(this.readDouble());
        }
        if (shape instanceof ShpPointM) {
            ((ShpPointM)shape).setM(this.readDouble());
        }
        return shape;
    }

    protected ShpPolygon readPolygon() throws IOException {
        return (ShpPolygon)this.readPolyLine(new ShpPolygon());
    }

    protected ShpPolygonM readPolygonM() throws IOException {
        return (ShpPolygonM)this.readPolyLine(new ShpPolygonM());
    }

    protected ShpPolygonZ readPolygonZ() throws IOException {
        return (ShpPolygonZ)this.readPolyLine(new ShpPolygonZ());
    }

    protected ShpMultiPatch readMultiPatch() throws IOException {
        return (ShpMultiPatch)this.readPolyLine(new ShpMultiPatch());
    }

    protected ShpPolyLine readPolyLine() throws IOException {
        return this.readPolyLine(new ShpPolyLine());
    }

    protected ShpPolyLineM readPolyLineM() throws IOException {
        return (ShpPolyLineM)this.readPolyLine(new ShpPolyLineM());
    }

    protected ShpPolyLineZ readPolyLineZ() throws IOException {
        return (ShpPolyLineZ)this.readPolyLine(new ShpPolyLineZ());
    }

    protected ShpMultiPoint readMultiPoint() throws IOException {
        return this.readMultiPoint(new ShpMultiPoint());
    }

    protected ShpMultiPointM readMultiPointM() throws IOException {
        return (ShpMultiPointM)this.readMultiPoint(new ShpMultiPointM());
    }

    protected ShpMultiPointZ readMultiPointZ() throws IOException {
        return (ShpMultiPointZ)this.readMultiPoint(new ShpMultiPointZ());
    }

    protected ShpPoint readPoint() throws IOException {
        return this.readPoint(new ShpPoint());
    }

    protected ShpPointM readPointM() throws IOException {
        return (ShpPointM)this.readPoint(new ShpPointM());
    }

    protected ShpPointZ readPointZ() throws IOException {
        return (ShpPointZ)this.readPoint(new ShpPointZ());
    }

    protected ShpUnsupportedShape readUnsupportedShape(int words) throws IOException {
        this.skipBytes(words * 2);
        return new ShpUnsupportedShape();
    }

    protected ShpNullShape readNullShape() {
        return new ShpNullShape();
    }

    protected int[] readIntArray(int size) throws IOException {
        int[] idxs = new int[size];
        int i = 0;
        while (i < size) {
            idxs[i] = this.readInt();
            ++i;
        }
        return idxs;
    }

    protected double[][] readAndWeavePoints(int rows, int pointCount) throws IOException {
        double[][] points = new double[rows][];
        int columns = pointCount;
        int idx = 0;
        while (idx < points.length) {
            points[idx] = new double[columns];
            ++idx;
        }
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                Point2D pt = this.readPointAndProject();
                points[row][column] = pt.getX();
                points[row + 1][column] = pt.getY();
                row += rows;
            }
            ++column;
        }
        return points;
    }

    protected double[] readPoints(int pointCount) throws IOException {
        double[] points = new double[pointCount];
        int row = 0;
        while (row < pointCount) {
            points[row] = this.readDouble();
            ++row;
        }
        return points;
    }

    protected Point2D transform(double x, double y) {
        if (this.coordinateSystem != null) {
            return this.coordinateSystem.inverseProject(x, y);
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D readPointAndProject() throws IOException {
        double lon = this.readDouble();
        double lat = this.readDouble();
        return this.transform(lon, lat);
    }

    protected int[] readPartBoundaries(int partCount) throws IOException {
        return this.readIntArray(partCount);
    }

    protected int[] readPartTypes(int partCount) throws IOException {
        return this.readIntArray(partCount);
    }

    protected Part[] readParts(int pointCount, int[] partBoundaries, int[] partTypes) throws IOException {
        Part[] parts = new Part[partBoundaries.length];
        int partType = 5;
        int idx = 0;
        while (idx < partBoundaries.length) {
            if (partTypes != null) {
                partType = partTypes[idx];
            }
            parts[idx] = new Part(partType, this.readAndWeavePoints(2, this.getPointCountForPart(idx, pointCount, partBoundaries)));
            ++idx;
        }
        return parts;
    }

    protected Range readRange() throws IOException {
        double min = this.readDouble();
        double max = this.readDouble();
        return new Range(min, max);
    }

    protected Box readBoundingBox(boolean transform) throws IOException {
        double xMin = this.readDouble();
        double yMin = this.readDouble();
        double xMax = this.readDouble();
        double yMax = this.readDouble();
        if (transform && this.coordinateSystem != null) {
            Point2D xyMin = this.transform(xMin, yMin);
            Point2D xyMax = this.transform(xMax, yMax);
            xMin = xyMin.getX();
            yMin = xyMin.getY();
            xMax = xyMax.getX();
            yMax = xyMax.getY();
        }
        return new Box(xMin, yMin, xMax, yMax);
    }

    protected void readMeasures(Part[] parts) throws IOException {
        int idx = 0;
        while (idx < parts.length) {
            double[] pts = this.readPoints(parts[idx].getPointCount());
            parts[idx].setMs(pts);
            ++idx;
        }
    }

    protected void readZCoordinates(Part[] parts) throws IOException {
        int idx = 0;
        while (idx < parts.length) {
            double[] pts = this.readPoints(parts[idx].getPointCount());
            parts[idx].setZs(pts);
            ++idx;
        }
    }

    protected int getPointCountForPart(int currentIdx, int pointCount, int[] partBoundaries) {
        if (currentIdx + 1 < partBoundaries.length) {
            return partBoundaries[currentIdx + 1] - partBoundaries[currentIdx];
        }
        return pointCount - partBoundaries[currentIdx];
    }
}

