/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.evolving.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.evolving.EvolvingFactory;
import org.eclipse.stem.diseasemodels.evolving.EvolvingPackage;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSEIRDiseaseModel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSEIRDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSEIRDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.evolving.impl.EvolvingSIRDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class EvolvingSEIRDiseaseModelImpl
extends EvolvingSIRDiseaseModelImpl
implements EvolvingSEIRDiseaseModel {
    protected static final double INCUBATION_RATE_EDEFAULT = 0.0;
    protected double incubationRate = 0.0;

    @Override
    protected EClass eStaticClass() {
        return EvolvingPackage.Literals.EVOLVING_SEIR_DISEASE_MODEL;
    }

    @Override
    public double getIncubationRate() {
        return this.incubationRate;
    }

    @Override
    public void setIncubationRate(double newIncubationRate) {
        this.incubationRate = newIncubationRate;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 33: {
                return this.getIncubationRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 33: {
                this.setIncubationRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 33: {
                this.setIncubationRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 33: {
                return this.incubationRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (incubationRate: ");
        result.append(this.incubationRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        double adjustedIncubationRate = this.getAdjustedIncubationRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SEIRLabelValue currentSEIR = (SEIRLabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSEIR.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSEIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSEIR.getR();
            double effectiveSusceptible = currentSEIR.getS();
            double popCount = currentSEIR.getS() + currentSEIR.getE() + currentSEIR.getI() + currentSEIR.getR();
            double crossProduct = 1.0;
            if (this.crossImmunityRate > 0.0 && effectiveSusceptible > 1.0) {
                Node thisNode = diseaseLabel.getNode();
                EList allLabels = thisNode.getLabels();
                for (NodeLabel nl : allLabels) {
                    EvolvingSEIRDiseaseModel otherSEIRDiease;
                    EvolvingSEIRDiseaseModelLabel seirLabel;
                    Decorator otherDisease;
                    if (!(nl instanceof EvolvingSEIRDiseaseModelLabel) || !((otherDisease = (seirLabel = (EvolvingSEIRDiseaseModelLabel)nl).getDecorator()) instanceof EvolvingSEIRDiseaseModel) || (otherSEIRDiease = (EvolvingSEIRDiseaseModel)otherDisease).getDiseaseName().equals(this.getDiseaseName())) continue;
                    EvolvingSEIRDiseaseModelLabelValue otherValue = (EvolvingSEIRDiseaseModelLabelValue)seirLabel.getCurrentValue();
                    double immuneTerm = otherValue.getR() / popCount;
                    double geneticDistance = this.getGeneticDistance(otherSEIRDiease);
                    if (geneticDistance >= 1.0) {
                        immuneTerm *= this.crossImmunityRate / geneticDistance;
                    }
                    if (!((crossProduct *= 1.0 - immuneTerm) < 0.0)) continue;
                    crossProduct = 0.0;
                }
            }
            double numberOfSusceptibleToExposed = 0.0;
            numberOfSusceptibleToExposed = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * effectiveSusceptible * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * (effectiveSusceptible *= crossProduct) * effectiveInfectious;
            double numberOfExposedToInfectious = adjustedIncubationRate * currentSEIR.getE();
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToExposed;
            double deltaE = numberOfSusceptibleToExposed - numberOfExposedToInfectious;
            double deltaI = numberOfExposedToInfectious - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            StandardInterventionLabel scl = this.findInterventionLabel((Node)diseaseLabel.getIdentifiable());
            if (scl != null) {
                double vaccinations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getVaccinations();
                double isolations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getIsolations();
                vaccinations *= (double)timeDelta / (double)this.getTimePeriod();
                isolations *= (double)timeDelta / (double)this.getTimePeriod();
                if (currentSEIR.getS() < vaccinations) {
                    vaccinations = currentSEIR.getS();
                }
                if (currentSEIR.getI() < isolations) {
                    isolations = currentSEIR.getI();
                }
                deltaS -= vaccinations;
                deltaR += vaccinations;
                deltaI -= isolations;
                deltaR += isolations;
            }
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfectious);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            SEIRLabelValueImpl ret = (SEIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    public void calculateEvolvedInitialState() {
        EvolvingSEIRDiseaseModel parentDiseaseModel = (EvolvingSEIRDiseaseModel)this.getParentDisease();
        DiseaseModelLabel parentEvolutionSource = this.getEvolvedAt();
        if (parentDiseaseModel == null && parentEvolutionSource == null) {
            System.err.println("Trying to calculate label state from an improperly initialized evolved model.  Do something.");
            return;
        }
        Node currentNode = parentEvolutionSource.getNode();
        URI evolutionLocation = currentNode.getURI();
        for (DynamicLabel dl : this.getLabelsToUpdate()) {
            double popCount;
            if (!(dl instanceof EvolvingSEIRDiseaseModelLabel)) continue;
            double s = 0.0;
            double e = 0.0;
            double i = 0.0;
            double r = 0.0;
            double diseaseDeaths = 0.0;
            EvolvingSEIRDiseaseModelLabel childLabel = (EvolvingSEIRDiseaseModelLabel)dl;
            EvolvingSEIRDiseaseModelLabelValue childLabelValues = (EvolvingSEIRDiseaseModelLabelValue)childLabel.getCurrentValue();
            EvolvingSEIRDiseaseModelLabel parentSEIRlabel = (EvolvingSEIRDiseaseModelLabel)parentEvolutionSource;
            childLabel.setPopulationLabel(parentSEIRlabel.getPopulationLabel());
            childLabel.setPopulationModelLabel(parentSEIRlabel.getPopulationModelLabel());
            EvolvingSEIRDiseaseModelLabelValue lv = (EvolvingSEIRDiseaseModelLabelValue)parentSEIRlabel.getCurrentValue();
            s = popCount = lv.getPopulationCount();
            if (childLabel.getNode().getURI().equals(evolutionLocation) && parentEvolutionSource instanceof EvolvingSEIRDiseaseModelLabel) {
                if (popCount > 1.0) {
                    e = 1.0;
                    s -= 1.0;
                } else {
                    System.err.println("Likely ERROR: Zero population detected on node " + currentNode.getURI().lastSegment() + " ...  Do something.");
                }
            }
            childLabelValues.setS(s);
            childLabelValues.setE(e);
            childLabelValues.setI(i);
            childLabelValues.setR(r);
            childLabelValues.setDiseaseDeaths(diseaseDeaths);
        }
    }

    protected void updateDuplicateEvolvedInitialState(Node currentNode) {
        URI evolutionLocation = currentNode.getURI();
        for (DynamicLabel dl : this.getLabelsToUpdate()) {
            if (!(dl instanceof EvolvingSEIRDiseaseModelLabel)) continue;
            EvolvingSEIRDiseaseModelLabel diseaseLabel = (EvolvingSEIRDiseaseModelLabel)dl;
            EvolvingSEIRDiseaseModelLabelValue childLabelValues = (EvolvingSEIRDiseaseModelLabelValue)diseaseLabel.getCurrentValue();
            double s = childLabelValues.getS();
            double e = childLabelValues.getE();
            double i = childLabelValues.getI();
            double r = childLabelValues.getR();
            double diseaseDeaths = childLabelValues.getDiseaseDeaths();
            if (diseaseLabel.getNode().getURI().equals(evolutionLocation) && s > 2.0) {
                e = 1.0;
                s -= 1.0;
            }
            childLabelValues.setS(s);
            childLabelValues.setE(e);
            childLabelValues.setI(i);
            childLabelValues.setR(r);
            childLabelValues.setDiseaseDeaths(diseaseDeaths);
        }
    }

    protected double getAdjustedIncubationRate(long timeDelta) {
        return this.getIncubationRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        EvolvingSEIRDiseaseModelLabel label = EvolvingFactory.eINSTANCE.createEvolvingSEIRDiseaseModelLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return EvolvingFactory.eINSTANCE.createEvolvingSEIRDiseaseModelLabelValue();
    }
}

