/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class XtextGeneratorResourceSetInitializer {
    private static final Logger LOG = Logger.getLogger(XtextGeneratorResourceSetInitializer.class);

    public void initialize(ResourceSet resourceSet, List<String> referencedResources) {
        StandaloneSetup delegate = new StandaloneSetup();
        delegate.setResourceSet(resourceSet);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        Consumer<String> _function = it -> this.loadResource((String)it, resourceSet);
        referencedResources.forEach(_function);
        this.registerGenModels(resourceSet);
        this.registerEPackages(resourceSet);
    }

    private void loadResource(String loadedResource, ResourceSet resourceSet) {
        URI loadedResourceUri = URI.createURI((String)loadedResource);
        this.ensureResourceCanBeLoaded(loadedResourceUri, resourceSet);
        resourceSet.getResource(loadedResourceUri, true);
    }

    private void ensureResourceCanBeLoaded(URI loadedResource, ResourceSet resourceSet) {
        String _fileExtension = loadedResource.fileExtension();
        if (_fileExtension != null) {
            switch (_fileExtension) {
                case "genmodel": {
                    GenModelPackage.eINSTANCE.getEFactoryInstance();
                    IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider != null) break;
                    try {
                        Class<?> genModelSupport = Class.forName("org.eclipse.emf.codegen.ecore.xtext.GenModelSupport");
                        Object instance = genModelSupport.newInstance();
                        genModelSupport.getDeclaredMethod("createInjectorAndDoEMFRegistration", new Class[0]).invoke(instance, new Object[0]);
                        break;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ClassNotFoundException) {
                            LOG.debug((Object)"org.eclipse.emf.codegen.ecore.xtext.GenModelSupport not found, GenModels will not be indexed");
                            break;
                        }
                        if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            LOG.error((Object)"Couldn't initialize GenModel support.", (Throwable)e_1);
                            break;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                case "ecore": {
                    IResourceServiceProvider resourceServiceProvider_1 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider_1 != null) break;
                    try {
                        Class<?> ecore = Class.forName("org.eclipse.xtext.ecore.EcoreSupportStandaloneSetup");
                        ecore.getDeclaredMethod("setup", new Class[0]).invoke(null, new Object[0]);
                        break;
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof ClassNotFoundException) {
                            ClassNotFoundException e_2 = (ClassNotFoundException)_t_1;
                            LOG.error((Object)"Couldn't initialize Ecore support. Is 'org.eclipse.xtext.ecore' on the classpath?");
                            LOG.debug((Object)e_2.getMessage(), (Throwable)e_2);
                            break;
                        }
                        if (_t_1 instanceof Exception) {
                            Exception e_3 = (Exception)_t_1;
                            LOG.error((Object)"Couldn't initialize Ecore support.", (Throwable)e_3);
                            break;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                case "xcore": {
                    IResourceServiceProvider resourceServiceProvider_2 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
                    if (resourceServiceProvider_2 == null) {
                        try {
                            Class<?> xcore = Class.forName("org.eclipse.emf.ecore.xcore.XcoreStandaloneSetup");
                            xcore.getDeclaredMethod("doSetup", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Throwable _t_2) {
                            if (_t_2 instanceof ClassNotFoundException) {
                                ClassNotFoundException e_4 = (ClassNotFoundException)_t_2;
                                LOG.error((Object)"Couldn't initialize Xcore support. Is it on the classpath?");
                                LOG.debug((Object)e_4.getMessage(), (Throwable)e_4);
                            }
                            if (_t_2 instanceof Exception) {
                                Exception e_5 = (Exception)_t_2;
                                LOG.error((Object)"Couldn't initialize Xcore support.", (Throwable)e_5);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_2);
                        }
                    }
                    URI xcoreLangURI = URI.createPlatformResourceURI((String)"/org.eclipse.emf.ecore.xcore.lib/model/XcoreLang.xcore", (boolean)true);
                    try {
                        resourceSet.getResource(xcoreLangURI, true);
                        break;
                    }
                    catch (Throwable _t_3) {
                        if (_t_3 instanceof WrappedException) {
                            WrappedException e_6 = (WrappedException)_t_3;
                            LOG.error((Object)"Could not load XcoreLang.xcore.", (Throwable)e_6);
                            Resource brokenResource = resourceSet.getResource(xcoreLangURI, false);
                            resourceSet.getResources().remove((Object)brokenResource);
                            break;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_3);
                    }
                }
            }
        }
    }

    private void registerEPackages(ResourceSet resourceSet) {
        Procedures.Procedure1 _function = it -> this.register((EPackage)it);
        this.each(resourceSet, EPackage.class, _function);
    }

    private void register(EPackage ePackage) {
        boolean _tripleEquals;
        EPackage.Registry registry = ePackage.eResource().getResourceSet().getPackageRegistry();
        Object _get = registry.get((Object)ePackage.getNsURI());
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
    }

    private void registerGenModels(ResourceSet resourceSet) {
        Procedures.Procedure1 _function = it -> this.register((GenModel)it);
        this.each(resourceSet, GenModel.class, _function);
    }

    private void register(GenModel genModel) {
        new GenModelHelper().registerGenModel(genModel);
    }

    private <Type> void each(ResourceSet resourceSet, Class<Type> type, Procedures.Procedure1<? super Type> strategy) {
        for (int i = 0; i < resourceSet.getResources().size(); ++i) {
            Resource resource = (Resource)resourceSet.getResources().get(i);
            Consumer<Object> _function = it -> strategy.apply(it);
            Iterables.filter((Iterable)resource.getContents(), type).forEach(_function);
        }
    }
}

